/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.utils;

import com.github.sachin.lootin.Lootin;
import com.github.sachin.lootin.utils.ContainerType;
import com.github.sachin.lootin.utils.ItemSerializer;
import com.github.sachin.lootin.utils.LConstants;
import com.github.sachin.lootin.version.VersionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.Lootable;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestUtils {
    public static boolean hasPlayerLoot(@Nullable Entity minecart, @Nullable BlockState block, @NotNull Player player, @NotNull ContainerType type) {
        NamespacedKey key = Lootin.getKey(player.getUniqueId().toString());
        if (type == ContainerType.CHEST) {
            Chest chest = (Chest)block;
            PersistentDataContainer data = chest.getPersistentDataContainer();
            return data.has(key, PersistentDataType.STRING);
        }
        if (type == ContainerType.BARREL) {
            Barrel barrel = (Barrel)block;
            PersistentDataContainer data = barrel.getPersistentDataContainer();
            return data.has(key, PersistentDataType.STRING);
        }
        if (type == ContainerType.MINECART) {
            StorageMinecart tileCart = (StorageMinecart)minecart;
            PersistentDataContainer data = tileCart.getPersistentDataContainer();
            return data.has(key, PersistentDataType.STRING);
        }
        if (type == ContainerType.DOUBLE_CHEST) {
            DoubleChest doubleChest = ChestUtils.getDoubleChest(block);
            PersistentDataContainer d1 = ((Chest)doubleChest.getLeftSide()).getPersistentDataContainer();
            PersistentDataContainer d2 = ((Chest)doubleChest.getRightSide()).getPersistentDataContainer();
            return d1.has(key, PersistentDataType.STRING) && d2.has(key, PersistentDataType.STRING);
        }
        return false;
    }

    public static boolean isLootinContainer(@Nullable Entity minecart, @Nullable BlockState block, @NotNull ContainerType type) {
        if (type == ContainerType.MINECART && minecart != null) {
            return ChestUtils.hasKey(((StorageMinecart)minecart).getPersistentDataContainer());
        }
        if (block != null) {
            if (type == ContainerType.CHEST) {
                return ChestUtils.hasKey(((Chest)block).getPersistentDataContainer());
            }
            if (type == ContainerType.BARREL) {
                return ChestUtils.hasKey(((Barrel)block).getPersistentDataContainer());
            }
            if (type == ContainerType.DOUBLE_CHEST && ChestUtils.isDoubleChest(block)) {
                DoubleChest doubleChest = ChestUtils.getDoubleChest(block);
                PersistentDataContainer d1 = ((Chest)doubleChest.getLeftSide()).getPersistentDataContainer();
                PersistentDataContainer d2 = ((Chest)doubleChest.getRightSide()).getPersistentDataContainer();
                return ChestUtils.hasKey(d1) && ChestUtils.hasKey(d2);
            }
        }
        return false;
    }

    public static void setLootinContainer(@Nullable Entity minecart, @Nullable BlockState block, @NotNull ContainerType type) {
        if (ChestUtils.isLootinContainer(minecart, block, type)) {
            return;
        }
        if (type == ContainerType.CHEST) {
            Chest chest = (Chest)block;
            PersistentDataContainer data = chest.getPersistentDataContainer();
            data.set(LConstants.IDENTITY_KEY, PersistentDataType.STRING, (Object)"");
            chest.update();
        } else if (type == ContainerType.MINECART) {
            minecart.getPersistentDataContainer().set(LConstants.IDENTITY_KEY, PersistentDataType.STRING, (Object)"");
        } else if (type == ContainerType.DOUBLE_CHEST && ChestUtils.isDoubleChest(block)) {
            DoubleChest doubleChest = ChestUtils.getDoubleChest(block);
            Chest c1 = (Chest)doubleChest.getLeftSide();
            Chest c2 = (Chest)doubleChest.getRightSide();
            ChestUtils.setLootinContainer(null, (BlockState)c1, ContainerType.CHEST);
            ChestUtils.setLootinContainer(null, (BlockState)c2, ContainerType.CHEST);
        } else if (type == ContainerType.BARREL) {
            Barrel barrel = (Barrel)block;
            PersistentDataContainer data = barrel.getPersistentDataContainer();
            data.set(LConstants.IDENTITY_KEY, PersistentDataType.STRING, (Object)"");
            barrel.update();
        }
    }

    public static List<ItemStack> getContainerItems(@Nullable Entity minecart, @Nullable BlockState block, @NotNull ContainerType type, @NotNull Player player) {
        String uuid = player.getUniqueId().toString();
        PersistentDataContainer data = null;
        Inventory inventory = null;
        if (type == ContainerType.CHEST) {
            Chest chest = (Chest)block;
            data = chest.getPersistentDataContainer();
            if (chest.getLootTable() != null) {
                VersionProvider.fillLoot(player, (Lootable)chest);
                chest.setLootTable(null);
            }
            inventory = chest.getInventory();
        } else if (type == ContainerType.MINECART) {
            StorageMinecart tileCart = (StorageMinecart)minecart;
            data = tileCart.getPersistentDataContainer();
            if (tileCart.getLootTable() != null) {
                VersionProvider.fillLoot(player, (Lootable)tileCart);
                tileCart.setLootTable(null);
            }
            inventory = tileCart.getInventory();
        } else if (type == ContainerType.BARREL) {
            Barrel barrel = (Barrel)block;
            data = barrel.getPersistentDataContainer();
            if (barrel.getLootTable() != null) {
                VersionProvider.fillLoot(player, (Lootable)barrel);
                barrel.setLootTable(null);
            }
            inventory = barrel.getInventory();
        } else if (type == ContainerType.DOUBLE_CHEST && ChestUtils.isDoubleChest(block)) {
            DoubleChest doubleChest = ChestUtils.getDoubleChest(block);
            Chest chestLeft = (Chest)doubleChest.getLeftSide();
            Chest chestRight = (Chest)doubleChest.getRightSide();
            boolean changed = false;
            if (chestLeft.getLootTable() != null) {
                VersionProvider.fillLoot(player, (Lootable)chestLeft);
                chestLeft.setLootTable(null);
                changed = true;
            }
            if (chestRight.getLootTable() != null) {
                VersionProvider.fillLoot(player, (Lootable)chestRight);
                chestRight.setLootTable(null);
                changed = true;
            }
            inventory = doubleChest.getInventory();
            if (!changed) {
                ArrayList<ItemStack> chestContents = new ArrayList<ItemStack>();
                ChestUtils.fillDoubleLoot(uuid, chestLeft, chestContents);
                ChestUtils.fillDoubleLoot(uuid, chestRight, chestContents);
                return chestContents;
            }
        } else {
            return null;
        }
        if (data != null && data.has(Lootin.getKey(uuid), PersistentDataType.STRING)) {
            return ItemSerializer.deserialize((String)data.get(Lootin.getKey(uuid), PersistentDataType.STRING));
        }
        if (data != null && data.has(LConstants.DATA_KEY, PersistentDataType.STRING)) {
            return ItemSerializer.deserialize((String)data.get(LConstants.DATA_KEY, PersistentDataType.STRING));
        }
        ArrayList<ItemStack> chestContents = new ArrayList<ItemStack>();
        Collections.addAll(chestContents, inventory.getContents());
        ChestUtils.setContainerItems(minecart, block, type, chestContents, "loot-container");
        inventory.clear();
        return chestContents;
    }

    private static void fillDoubleLoot(String uuid, Chest chest, ArrayList<ItemStack> items) {
        PersistentDataContainer data = chest.getPersistentDataContainer();
        if (data.has(Lootin.getKey(uuid), PersistentDataType.STRING)) {
            items.addAll(ItemSerializer.deserialize((String)data.get(Lootin.getKey(uuid), PersistentDataType.STRING)));
            return;
        }
        if (!data.has(LConstants.DATA_KEY, PersistentDataType.STRING)) {
            return;
        }
        items.addAll(ItemSerializer.deserialize((String)data.get(LConstants.DATA_KEY, PersistentDataType.STRING)));
    }

    public static void setContainerItems(@Nullable Entity minecart, @Nullable BlockState block, @NotNull ContainerType type, @NotNull List<ItemStack> items, String key) {
        if (type == ContainerType.CHEST) {
            Chest chest = (Chest)block;
            PersistentDataContainer data = chest.getPersistentDataContainer();
            data.set(Lootin.getKey(key), PersistentDataType.STRING, (Object)ItemSerializer.serialize(items));
            chest.update();
        } else if (type == ContainerType.MINECART) {
            StorageMinecart tileCart = (StorageMinecart)minecart;
            PersistentDataContainer data = tileCart.getPersistentDataContainer();
            data.set(Lootin.getKey(key), PersistentDataType.STRING, (Object)ItemSerializer.serialize(items));
        } else if (type == ContainerType.BARREL) {
            Barrel barrel = (Barrel)block;
            PersistentDataContainer data = barrel.getPersistentDataContainer();
            data.set(Lootin.getKey(key), PersistentDataType.STRING, (Object)ItemSerializer.serialize(items));
            barrel.update();
        } else if (type == ContainerType.DOUBLE_CHEST && ChestUtils.isDoubleChest(block)) {
            DoubleChest doubleChest = ChestUtils.getDoubleChest(block);
            Chest c1 = (Chest)doubleChest.getLeftSide();
            Chest c2 = (Chest)doubleChest.getRightSide();
            ChestUtils.setContainerItems(null, (BlockState)c1, ContainerType.CHEST, items.subList(0, 26), key);
            ChestUtils.setContainerItems(null, (BlockState)c2, ContainerType.CHEST, items.subList(26, 53), key);
        }
    }

    public static DoubleChest getDoubleChest(BlockState block) {
        Chest chest = (Chest)block;
        return (DoubleChest)chest.getInventory().getHolder();
    }

    public static boolean isDoubleChest(BlockState block) {
        return block instanceof Chest && ((Chest)block).getInventory().getHolder() instanceof DoubleChest;
    }

    private static boolean hasKey(PersistentDataContainer data) {
        return data.has(LConstants.IDENTITY_KEY, PersistentDataType.STRING);
    }

    public static boolean isChest(Material mat) {
        return mat == Material.CHEST || mat == Material.TRAPPED_CHEST;
    }
}

