/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.listeners;

import com.github.sachin.lootin.gui.BarrelGui;
import com.github.sachin.lootin.gui.ChestGui;
import com.github.sachin.lootin.gui.DoubleChestGui;
import com.github.sachin.lootin.gui.GuiHolder;
import com.github.sachin.lootin.gui.MinecartGui;
import com.github.sachin.lootin.listeners.BaseListener;
import com.github.sachin.lootin.utils.ChestUtils;
import com.github.sachin.lootin.utils.ContainerType;
import com.github.sachin.lootin.utils.cooldown.Cooldown;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.loot.Lootable;

public class InventoryListeners
extends BaseListener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent e) {
        ContainerType container;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = e.getPlayer();
        Block block = e.getClickedBlock();
        BlockState state = block.getState();
        Material type = state.getType();
        boolean isLootin = false;
        if (ChestUtils.isChest(type)) {
            container = ChestUtils.isDoubleChest(state) ? ContainerType.DOUBLE_CHEST : ContainerType.CHEST;
            isLootin = ChestUtils.isLootinContainer(null, state, container);
        } else if (type == Material.BARREL) {
            container = ContainerType.BARREL;
            isLootin = ChestUtils.isLootinContainer(null, state, container);
        } else {
            return;
        }
        if (!isLootin && ((Lootable)state).getLootTable() != null) {
            if (this.plugin.getBlackListStructures().contains(((Lootable)state).getLootTable().getKey())) {
                return;
            }
            ChestUtils.setLootinContainer(null, state, container);
            isLootin = true;
        }
        if (!isLootin || e.useInteractedBlock() == Event.Result.DENY && !this.plugin.getConfig().getBoolean("bypass-grief-plugins")) {
            return;
        }
        if (player.isSneaking()) {
            e.setCancelled(true);
            return;
        }
        e.setUseInteractedBlock(Event.Result.DENY);
        Cooldown cooldown = this.plugin.interactCooldown.get(player.getUniqueId());
        if (!cooldown.isTriggerable()) {
            return;
        }
        cooldown.trigger();
        switch (container) {
            case CHEST: {
                if (this.plugin.currentChestviewers.contains(block.getLocation())) {
                    return;
                }
                new ChestGui(player, (Chest)state).open();
                return;
            }
            case DOUBLE_CHEST: {
                if (this.plugin.currentChestviewers.contains(block.getLocation())) {
                    return;
                }
                new DoubleChestGui(player, (BlockState)((Chest)((DoubleChest)((Chest)state).getInventory().getHolder()).getLeftSide())).open();
                return;
            }
            case BARREL: {
                if (this.plugin.currentChestviewers.contains(block.getLocation())) {
                    return;
                }
                new BarrelGui(player, (Barrel)state).open();
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMinecartInteract(PlayerInteractEntityEvent e) {
        if (!(e.getRightClicked() instanceof StorageMinecart)) {
            return;
        }
        StorageMinecart minecart = (StorageMinecart)e.getRightClicked();
        if (!ChestUtils.isLootinContainer((Entity)minecart, null, ContainerType.MINECART)) {
            if (minecart.getLootTable() == null || this.plugin.getBlackListStructures().contains(minecart.getLootTable().getKey())) {
                return;
            }
            ChestUtils.setLootinContainer((Entity)minecart, null, ContainerType.MINECART);
        }
        if (e.isCancelled() && !this.plugin.getConfig().getBoolean("bypass-grief-plugins")) {
            return;
        }
        e.setCancelled(true);
        Player player = e.getPlayer();
        Cooldown cooldown = this.plugin.interactCooldown.get(player.getUniqueId());
        if (!cooldown.isTriggerable()) {
            return;
        }
        cooldown.trigger();
        if (this.plugin.currentMinecartviewers.contains(minecart)) {
            return;
        }
        new MinecartGui(player, minecart).open();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() instanceof GuiHolder) {
            ((GuiHolder)e.getInventory().getHolder()).close();
        }
    }
}

