/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.listeners;

import com.github.sachin.lootin.Lootin;
import com.github.sachin.lootin.listeners.BaseListener;
import com.github.sachin.lootin.utils.LConstants;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkLoadListener
extends BaseListener {
    @EventHandler
    public void onRemove(HangingBreakEvent e) {
        if (e.getEntity().getPersistentDataContainer().has(LConstants.ITEM_FRAME_ELYTRA_KEY, PersistentDataType.INTEGER)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onElytraRemove(EntityDamageByEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntity().getType() == EntityType.ITEM_FRAME && this.plugin.getConfig().getBoolean("per-player-elytra-item-frame")) {
            ItemFrame framea = (ItemFrame)e.getEntity();
            if (!framea.getPersistentDataContainer().has(LConstants.ITEM_FRAME_ELYTRA_KEY, PersistentDataType.INTEGER)) {
                return;
            }
            e.setCancelled(true);
            if (e.getDamager() instanceof Player) {
                Player player = (Player)e.getDamager();
                String uuid = player.getUniqueId().toString();
                NamespacedKey playerKey = Lootin.getKey(uuid);
                if (framea.getPersistentDataContainer().has(playerKey, PersistentDataType.INTEGER)) {
                    if (player.hasPermission("looter.breakelytraitemframe.bypass")) {
                        if (player.getInventory().getItemInMainHand().getType() == Material.STICK) {
                            framea.remove();
                            player.sendMessage(this.plugin.getMessage("messages.elytra-item-frame-removed", player));
                        } else {
                            player.sendMessage(this.plugin.getMessage("messages.elytra-itemframe-break-with-permission", player));
                        }
                    } else {
                        player.sendMessage(this.plugin.getMessage("messages.elytra-itemframe-break-without-permission", player));
                    }
                    return;
                }
                framea.getPersistentDataContainer().set(playerKey, PersistentDataType.INTEGER, (Object)1);
                Location loc = framea.getLocation().getBlock().getLocation();
                BlockFace face = framea.getFacing();
                framea.getWorld().dropItemNaturally(new Location(framea.getWorld(), loc.getX() + (double)((float)face.getModX() * 0.15f), loc.getY() + (double)0.15f, loc.getZ() + (double)((float)face.getModZ() * 0.15f)), new ItemStack(Material.ELYTRA));
                if (this.plugin.isRunningProtocolLib) {
                    framea.setItem(new ItemStack(Material.ELYTRA));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(final ChunkLoadEvent e) {
        final Chunk chunk = e.getChunk();
        new BukkitRunnable(){

            public void run() {
                if (!chunk.isLoaded()) {
                    return;
                }
                if (e.isNewChunk() && chunk.getWorld().getEnvironment() == World.Environment.THE_END && ChunkLoadListener.this.plugin.getConfig().getBoolean("per-player-elytra-item-frame")) {
                    for (Entity entity : chunk.getEntities()) {
                        ItemFrame frame;
                        if (entity.getType() != EntityType.ITEM_FRAME || (frame = (ItemFrame)entity).getItem() == null || frame.getItem().getType() != Material.ELYTRA) continue;
                        frame.getPersistentDataContainer().set(LConstants.ITEM_FRAME_ELYTRA_KEY, PersistentDataType.INTEGER, (Object)1);
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }
}

