/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.listeners;

import com.github.sachin.lootin.listeners.BaseListener;
import com.github.sachin.lootin.utils.ChestUtils;
import com.github.sachin.lootin.utils.ContainerType;
import com.github.sachin.lootin.utils.LConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestEvents
extends BaseListener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onChestBreak(BlockBreakEvent e) {
        Barrel barrel;
        Player player = e.getPlayer();
        Block block = e.getBlock();
        if (ChestUtils.isChest(block.getType())) {
            Chest chest = (Chest)block.getState();
            if (ChestUtils.isLootinContainer(null, (BlockState)chest, ContainerType.CHEST)) {
                if (this.plugin.currentChestviewers.contains(chest.getLocation())) {
                    player.sendMessage(this.plugin.getMessage("messages.chest-edited", player));
                    e.setCancelled(true);
                    return;
                }
                if (player.hasPermission("looter.breakchest.bypass")) {
                    if (player.isSneaking()) {
                        List<ItemStack> items;
                        chest.getInventory().clear();
                        if (!this.plugin.getConfig().getBoolean("delete-items-on-break") && ChestUtils.hasPlayerLoot(null, (BlockState)chest, player, ContainerType.CHEST) && (items = ChestUtils.getContainerItems(null, (BlockState)chest, ContainerType.CHEST, player)) != null) {
                            items.forEach(i -> {
                                if (i != null) {
                                    player.getWorld().dropItemNaturally(block.getLocation(), i);
                                }
                            });
                        }
                    } else {
                        player.sendMessage(this.plugin.getMessage("messages.chestbreak-with-permission", player));
                        e.setCancelled(true);
                    }
                } else {
                    e.setCancelled(true);
                    player.sendMessage(this.plugin.getMessage("messages.chestbreak-without-permission", player));
                }
            }
        } else if (block.getType() == Material.BARREL && ChestUtils.isLootinContainer(null, (BlockState)(barrel = (Barrel)block.getState()), ContainerType.BARREL)) {
            if (this.plugin.currentChestviewers.contains(barrel.getLocation())) {
                player.sendMessage(this.plugin.getMessage("messages.chest-edited", player));
                e.setCancelled(true);
                return;
            }
            if (player.hasPermission("looter.breakchest.bypass")) {
                if (player.isSneaking()) {
                    List<ItemStack> items;
                    barrel.getInventory().clear();
                    if (!this.plugin.getConfig().getBoolean("delete-items-on-break") && ChestUtils.hasPlayerLoot(null, (BlockState)barrel, player, ContainerType.BARREL) && (items = ChestUtils.getContainerItems(null, (BlockState)barrel, ContainerType.BARREL, player)) != null) {
                        items.forEach(i -> {
                            if (i != null) {
                                player.getWorld().dropItemNaturally(block.getLocation(), i);
                            }
                        });
                    }
                } else {
                    player.sendMessage(this.plugin.getMessage("messages.chestbreak-with-permission", player));
                    e.setCancelled(true);
                }
            } else {
                e.setCancelled(true);
                player.sendMessage(this.plugin.getMessage("messages.chestbreak-without-permission", player));
            }
        }
    }

    @EventHandler
    public void onItemMove(InventoryMoveItemEvent e) {
        List<InventoryHolder> holders = Arrays.asList(e.getSource().getHolder(), e.getDestination().getHolder());
        for (InventoryHolder h1 : holders) {
            if (h1 == null) {
                return;
            }
            if (h1 instanceof DoubleChest) {
                DoubleChest doubleChest = (DoubleChest)h1;
                PersistentDataContainer d1 = ((Chest)doubleChest.getLeftSide()).getPersistentDataContainer();
                PersistentDataContainer d2 = ((Chest)doubleChest.getRightSide()).getPersistentDataContainer();
                if (!d1.has(LConstants.IDENTITY_KEY, PersistentDataType.STRING) && !d2.has(LConstants.IDENTITY_KEY, PersistentDataType.STRING)) continue;
                e.setCancelled(true);
                continue;
            }
            if (h1 instanceof Chest) {
                if (!ChestUtils.isLootinContainer(null, (BlockState)((Chest)h1), ContainerType.CHEST)) continue;
                e.setCancelled(true);
                continue;
            }
            if (h1 instanceof StorageMinecart) {
                if (!ChestUtils.isLootinContainer((Entity)((StorageMinecart)h1), null, ContainerType.MINECART)) continue;
                e.setCancelled(true);
                continue;
            }
            if (!(h1 instanceof Barrel) || !ChestUtils.isLootinContainer(null, (BlockState)((Barrel)h1), ContainerType.BARREL)) continue;
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockExplode(EntityExplodeEvent e) {
        if (!this.plugin.getConfig().getBoolean("prevent-explosions")) {
            return;
        }
        ArrayList<Block> chestBlocks = new ArrayList<Block>();
        for (Block block : e.blockList()) {
            BlockState state = block.getState();
            if (state instanceof Chest) {
                if (!ChestUtils.isLootinContainer(null, state, ContainerType.CHEST)) continue;
                chestBlocks.add(block);
                continue;
            }
            if (!(state instanceof Barrel) || !ChestUtils.isLootinContainer(null, state, ContainerType.BARREL)) continue;
            chestBlocks.add(block);
        }
        for (Block block : chestBlocks) {
            e.blockList().remove(block);
        }
    }

    @EventHandler
    public void onMinecartDestroy(VehicleDestroyEvent e) {
        if (!(e.getVehicle() instanceof StorageMinecart)) {
            return;
        }
        StorageMinecart chest = (StorageMinecart)e.getVehicle();
        if (ChestUtils.isLootinContainer((Entity)e.getVehicle(), null, ContainerType.MINECART)) {
            if (this.plugin.currentMinecartviewers.contains(chest)) {
                e.setCancelled(true);
                return;
            }
            if (e.getAttacker() instanceof Player) {
                Player player = (Player)e.getAttacker();
                if (player.hasPermission("looter.breakchest.bypass")) {
                    if (player.isSneaking()) {
                        List<ItemStack> items;
                        chest.getInventory().clear();
                        if (!this.plugin.getConfig().getBoolean("delete-items-on-break") && ChestUtils.hasPlayerLoot((Entity)chest, null, player, ContainerType.MINECART) && (items = ChestUtils.getContainerItems((Entity)chest, null, ContainerType.MINECART, player)) != null) {
                            items.forEach(i -> {
                                if (i != null) {
                                    player.getWorld().dropItemNaturally(chest.getLocation(), i);
                                }
                            });
                        }
                    } else {
                        player.sendMessage(this.plugin.getMessage("messages.chestbreak-with-permission", player));
                        e.setCancelled(true);
                    }
                } else {
                    e.setCancelled(true);
                    player.sendMessage(this.plugin.getMessage("messages.chestbreak-without-permission", player));
                }
            } else if (this.plugin.getConfig().getBoolean("prevent-explosions")) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onChestPlace(final PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getItem() == null) {
            return;
        }
        if (!ChestUtils.isChest(e.getMaterial())) {
            return;
        }
        final Block b = e.getClickedBlock().getRelative(e.getBlockFace());
        final Player player = e.getPlayer();
        new BukkitRunnable(){

            public void run() {
                if (!ChestUtils.isChest(b.getType())) {
                    return;
                }
                for (BlockFace face : Arrays.asList(BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH)) {
                    Chest chest;
                    Block block = b.getRelative(face);
                    if (!(block.getState() instanceof Chest) || !ChestUtils.isLootinContainer(null, (BlockState)(chest = (Chest)block.getState()), ContainerType.CHEST)) continue;
                    b.setType(Material.AIR);
                    player.getWorld().dropItemNaturally(b.getLocation(), new ItemStack(e.getMaterial()));
                    player.sendMessage(ChestEvents.this.plugin.getMessage("messages.cant-place-double-chest", player));
                    break;
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }
}

