/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.gui;

import com.github.sachin.lootin.gui.GuiHolder;
import com.github.sachin.lootin.utils.ChestUtils;
import com.github.sachin.lootin.utils.ContainerType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DoubleChestGui
extends GuiHolder {
    private BlockState block;
    private DoubleChest doubleChest;

    public DoubleChestGui(Player player, BlockState block) {
        super(player, ContainerType.DOUBLE_CHEST);
        this.block = block;
        this.doubleChest = ChestUtils.getDoubleChest(block);
    }

    @Override
    public void open() {
        List<ItemStack> items = ChestUtils.getContainerItems(null, this.block, this.type, this.player);
        if (items != null) {
            this.inventory.setContents(items.toArray(new ItemStack[0]));
            this.player.openInventory(this.inventory);
            ((Chest)this.block).open();
            if (this.plugin.isRunningProtocolLib) {
                this.player.getWorld().playSound(this.player.getLocation(), Sound.BLOCK_CHEST_OPEN, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            this.plugin.currentChestviewers.add(((Chest)this.doubleChest.getLeftSide()).getLocation());
            this.plugin.currentChestviewers.add(((Chest)this.doubleChest.getRightSide()).getLocation());
        }
    }

    @Override
    public void close() {
        List<ItemStack> contents = Arrays.asList(this.inventory.getContents());
        if (contents != null) {
            ChestUtils.setContainerItems(null, this.block, this.type, contents, this.player.getUniqueId().toString());
        }
        ((Chest)this.block).close();
        if (this.plugin.isRunningProtocolLib) {
            this.player.getWorld().playSound(this.player.getLocation(), Sound.BLOCK_CHEST_CLOSE, SoundCategory.PLAYERS, 0.5f, 1.0f);
        }
        this.plugin.currentChestviewers.remove(((Chest)this.doubleChest.getLeftSide()).getLocation());
        this.plugin.currentChestviewers.remove(((Chest)this.doubleChest.getRightSide()).getLocation());
    }
}

