/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.gui;

import com.github.sachin.lootin.gui.GuiHolder;
import com.github.sachin.lootin.utils.ChestUtils;
import com.github.sachin.lootin.utils.ContainerType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChestGui
extends GuiHolder {
    private Chest chest;

    public ChestGui(Player player, Chest chest) {
        super(player, ContainerType.CHEST);
        this.chest = chest;
    }

    @Override
    public void open() {
        List<ItemStack> contents = ChestUtils.getContainerItems(null, (BlockState)this.chest, ContainerType.CHEST, this.player);
        if (contents != null) {
            this.inventory.setContents(contents.toArray(new ItemStack[0]));
            this.player.openInventory(this.inventory);
            this.chest.open();
            if (this.plugin.isRunningProtocolLib) {
                this.player.getWorld().playSound(this.player.getLocation(), Sound.BLOCK_CHEST_OPEN, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            this.plugin.currentChestviewers.add(this.chest.getLocation());
        }
    }

    @Override
    public void close() {
        List<ItemStack> contents = Arrays.asList(this.inventory.getContents());
        if (contents != null) {
            ChestUtils.setContainerItems(null, (BlockState)this.chest, this.type, contents, this.player.getUniqueId().toString());
        }
        this.chest.close();
        if (this.plugin.isRunningProtocolLib) {
            this.player.getWorld().playSound(this.player.getLocation(), Sound.BLOCK_CHEST_CLOSE, SoundCategory.PLAYERS, 0.5f, 1.0f);
        }
        this.plugin.currentChestviewers.remove(this.chest.getLocation());
    }
}

