/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.gui;

import com.github.sachin.lootin.gui.GuiHolder;
import com.github.sachin.lootin.utils.ChestUtils;
import com.github.sachin.lootin.utils.ContainerType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BarrelGui
extends GuiHolder {
    private Barrel barrel;

    public BarrelGui(Player player, Barrel barrel) {
        super(player, ContainerType.BARREL);
        this.barrel = barrel;
    }

    @Override
    public void open() {
        List<ItemStack> contents = ChestUtils.getContainerItems(null, (BlockState)this.barrel, this.type, this.player);
        if (contents != null) {
            this.inventory.setContents(contents.toArray(new ItemStack[0]));
            this.player.openInventory(this.inventory);
            this.barrel.open();
            this.plugin.currentChestviewers.add(this.barrel.getLocation());
        }
    }

    @Override
    public void close() {
        List<ItemStack> contents = Arrays.asList(this.inventory.getContents());
        if (contents != null) {
            ChestUtils.setContainerItems(null, (BlockState)this.barrel, this.type, contents, this.player.getUniqueId().toString());
        }
        this.barrel.close();
        this.plugin.currentChestviewers.remove(this.barrel.getLocation());
    }
}

