/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Subcommand;
import com.github.sachin.lootin.Lootin;
import com.github.sachin.lootin.utils.ChestUtils;
import com.github.sachin.lootin.utils.ContainerType;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.util.RayTraceResult;

@CommandAlias(value="lootin")
public class Commands
extends BaseCommand {
    private Lootin plugin;

    public Commands(Lootin plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="reload")
    public void onCommand(CommandSender sender) {
        if (sender.hasPermission("looter.command.reload")) {
            this.plugin.reloadConfigs();
            sender.sendMessage(this.plugin.getMessage("messages.reloaded", null));
        } else {
            sender.sendMessage(this.plugin.getMessage("messages.no-permission", null));
        }
    }

    @Subcommand(value="set")
    @CommandCompletion(value="CHEST|BARREL|MINECART")
    public void onSet(Player player, String[] args) {
        if (args.length < 1) {
            return;
        }
        if (!player.hasPermission("looter.command.set")) {
            player.sendMessage(this.plugin.getMessage("messages.no-permission", null));
            return;
        }
        String type = args[0];
        RayTraceResult ray = player.rayTraceBlocks(4.0);
        if (type.equals("CHEST")) {
            if (ray != null && ray.getHitBlock().getType() == Material.CHEST) {
                Chest chest = (Chest)ray.getHitBlock().getState();
                if (!chest.getInventory().isEmpty()) {
                    ChestUtils.setLootinContainer(null, (BlockState)chest, ContainerType.CHEST);
                    player.sendMessage(this.plugin.getMessage("&aChest set as looter container successfully, the contents of chest are per player now!", player));
                } else {
                    player.sendMessage(this.plugin.getMessage("&cChest is empty!", player));
                }
            } else {
                player.sendMessage(this.plugin.getMessage("&cLook at chest while executing command!", player));
            }
        } else if (type.equals("BARREL")) {
            if (ray != null && ray.getHitBlock().getType() == Material.BARREL) {
                Barrel barrel = (Barrel)ray.getHitBlock().getState();
                if (!barrel.getInventory().isEmpty()) {
                    ChestUtils.setLootinContainer(null, (BlockState)barrel, ContainerType.BARREL);
                    player.sendMessage(this.plugin.getMessage("&aBarrel set as looter container successfully, the contents of barrel are per player now!", player));
                } else {
                    player.sendMessage(this.plugin.getMessage("&cBarrel is empty!", player));
                }
            } else {
                player.sendMessage(this.plugin.getMessage("&cLook at barrel while executing command!", player));
            }
        } else if (type.equals("MINECART")) {
            RayTraceResult raytrace = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 4.0, en -> en.getType() == EntityType.MINECART_CHEST);
            if (raytrace != null && raytrace.getHitEntity() != null) {
                StorageMinecart minecart = (StorageMinecart)raytrace.getHitEntity();
                if (!minecart.getInventory().isEmpty()) {
                    ChestUtils.setLootinContainer((Entity)minecart, null, ContainerType.MINECART);
                    player.sendMessage(this.plugin.getMessage("&aChest Minecart set as looter container successfully, the contents of minecart are per player now!", player));
                } else {
                    player.sendMessage(this.plugin.getMessage("&cMinecart is empty!", player));
                }
            } else {
                player.sendMessage(this.plugin.getMessage("&cLook at Chest Minecart while executing command!", player));
            }
        }
    }
}

