/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin;

import co.aikar.commands.PaperCommandManager;
import com.github.sachin.lootin.commands.Commands;
import com.github.sachin.lootin.listeners.ChestEvents;
import com.github.sachin.lootin.listeners.ChunkLoadListener;
import com.github.sachin.lootin.listeners.EntityMetaDataPacketListener;
import com.github.sachin.lootin.listeners.InventoryListeners;
import com.github.sachin.lootin.listeners.integration.CustomStructuresLootPopulateEvent;
import com.github.sachin.lootin.listeners.integration.OTDLootListener;
import com.github.sachin.lootin.utils.ConfigUpdater;
import com.github.sachin.lootin.utils.Metrics;
import com.github.sachin.lootin.utils.cooldown.CooldownContainer;
import com.github.sachin.lootin.version.VersionProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Listener;
import org.bukkit.loot.LootTables;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Lootin
extends JavaPlugin {
    private static Lootin plugin;
    private PaperCommandManager commandManager;
    public List<Location> currentChestviewers = new ArrayList<Location>();
    public List<StorageMinecart> currentMinecartviewers = new ArrayList<StorageMinecart>();
    public CooldownContainer interactCooldown;
    public boolean isRunningPurpur;
    public boolean isRunningProtocolLib;

    public void onEnable() {
        plugin = this;
        try {
            Class.forName("net.pl3x.purpur.event.PlayerAFKEvent");
            this.isRunningPurpur = true;
        }
        catch (ClassNotFoundException e) {
            this.isRunningPurpur = false;
        }
        VersionProvider.setup();
        this.interactCooldown = new CooldownContainer();
        this.interactCooldown.setCooldown(350L);
        this.interactCooldown.getTimer().setRunning(true);
        this.isRunningProtocolLib = this.getServer().getPluginManager().getPlugin("ProtocolLib") != null;
        this.commandManager = new PaperCommandManager((Plugin)plugin);
        this.commandManager.registerCommand(new Commands(plugin));
        this.reloadConfigs();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new ChunkLoadListener(), (Plugin)plugin);
        pm.registerEvents((Listener)new InventoryListeners(), (Plugin)plugin);
        pm.registerEvents((Listener)new ChestEvents(), (Plugin)plugin);
        if (pm.isPluginEnabled("CustomStructures")) {
            this.getLogger().info("Found custom structures, registering listeners...");
            pm.registerEvents((Listener)new CustomStructuresLootPopulateEvent(), (Plugin)plugin);
        }
        if (pm.isPluginEnabled("Oh_the_dungeons_youll_go")) {
            this.getLogger().info("Found OhTheDungeons, registering listeners...");
            pm.registerEvents((Listener)new OTDLootListener(), (Plugin)plugin);
        }
        if (this.isRunningProtocolLib) {
            this.getLogger().info("Found ProtocolLib, registering meta data packet listener...");
            new EntityMetaDataPacketListener();
        }
        if (this.getConfig().getBoolean("metrics", true)) {
            this.getLogger().info("Enabling bstats...");
            new Metrics(this, 11877);
        }
    }

    public void onDisable() {
        if (this.interactCooldown != null) {
            this.interactCooldown.getTimer().setRunning(false);
            this.interactCooldown.getTimer().kill();
            this.interactCooldown = null;
        }
        VersionProvider.PROVIDER.deleteAll();
    }

    public static Lootin getPlugin() {
        return plugin;
    }

    public static NamespacedKey getKey(String key) {
        return new NamespacedKey((Plugin)plugin, key);
    }

    public String getMessage(String key, Player player) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getConfig().getString("messages.prefix") + this.getConfig().getString(key, key)));
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") && player != null) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        return message;
    }

    public String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"));
    }

    public String getTitle(String key) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString(key, "Error"));
    }

    public List<String> getBlackListWorlds() {
        List list;
        if (this.getConfig().contains("black-list-worlds") && (list = this.getConfig().getStringList("black-list-worlds")) != null) {
            return list;
        }
        return new ArrayList<String>();
    }

    public List<NamespacedKey> getBlackListStructures() {
        List list = new ArrayList();
        ArrayList<NamespacedKey> keyList = new ArrayList<NamespacedKey>();
        try {
            list = plugin.getConfig().getStringList("black-list-structures");
            if (list.isEmpty() || list == null) {
                return keyList;
            }
            list.forEach(s -> {
                if (LootTables.valueOf((String)s) != null) {
                    keyList.add(LootTables.valueOf((String)s).getKey());
                }
            });
            return keyList;
        }
        catch (Exception e) {
            return keyList;
        }
    }

    public int getBarrelRowCount() {
        if (this.isRunningPurpur) {
            File file = new File("purpur.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            return config.getInt("settings.blocks.barrel.rows", 3) * 9;
        }
        return 27;
    }

    public void reloadConfigs() {
        this.saveDefaultConfig();
        try {
            ConfigUpdater.update((Plugin)plugin, "config.yml", new File(this.getDataFolder(), "config.yml"), new ArrayList<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reloadConfig();
        this.getLogger().info("Config file reloaded");
    }

    public PaperCommandManager getCommandManager() {
        return this.commandManager;
    }
}

