/*
 * Decompiled with CFR 0.152.
 */
package me.bruno.login.manager;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import me.bruno.login.Main;
import me.bruno.login.manager.ResourceInfo;
import me.bruno.login.manager.ResourceVersion;
import me.bruno.login.manager.UpdateCallback;
import me.bruno.login.manager.comparator.VersionComparator;
import org.bukkit.Bukkit;

public abstract class SpigetUpdateAbstract {
    public static final String RESOURCE_INFO = "http://api.spiget.org/v2/resources/%s?ut=%s";
    public static final String RESOURCE_VERSION = "http://api.spiget.org/v2/resources/%s/versions/latest?ut=%s";
    protected final int resourceId;
    protected final String currentVersion;
    protected final Logger log;
    protected String userAgent = "SpigetResourceUpdater";
    protected VersionComparator versionComparator = VersionComparator.EQUAL;
    protected ResourceInfo latestResourceInfo;

    public SpigetUpdateAbstract(int resourceId, String currentVersion, Logger log) {
        this.resourceId = resourceId;
        this.currentVersion = currentVersion;
        this.log = log;
    }

    public SpigetUpdateAbstract setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public SpigetUpdateAbstract setVersionComparator(VersionComparator comparator) {
        this.versionComparator = comparator;
        return this;
    }

    public ResourceInfo getLatestResourceInfo() {
        return this.latestResourceInfo;
    }

    protected abstract void dispatch(Runnable var1);

    public boolean isVersionNewer(String oldVersion, String newVersion) {
        return this.versionComparator.isNewer(oldVersion, newVersion);
    }

    public void checkForUpdate(final UpdateCallback callback) {
        this.dispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL(String.format(SpigetUpdateAbstract.RESOURCE_INFO, SpigetUpdateAbstract.this.resourceId, System.currentTimeMillis())).openConnection();
                    connection.setRequestProperty("User-Agent", SpigetUpdateAbstract.this.getUserAgent());
                    JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
                    SpigetUpdateAbstract.this.latestResourceInfo = (ResourceInfo)new Gson().fromJson((JsonElement)jsonObject, ResourceInfo.class);
                    connection = (HttpURLConnection)new URL(String.format(SpigetUpdateAbstract.RESOURCE_VERSION, SpigetUpdateAbstract.this.resourceId, System.currentTimeMillis())).openConnection();
                    connection.setRequestProperty("User-Agent", SpigetUpdateAbstract.this.getUserAgent());
                    jsonObject = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
                    SpigetUpdateAbstract.this.latestResourceInfo.latestVersion = (ResourceVersion)new Gson().fromJson((JsonElement)jsonObject, ResourceVersion.class);
                    if (SpigetUpdateAbstract.this.isVersionNewer(SpigetUpdateAbstract.this.currentVersion, SpigetUpdateAbstract.this.latestResourceInfo.latestVersion.name)) {
                        callback.updateAvailable(SpigetUpdateAbstract.this.latestResourceInfo.latestVersion.name, "https://spigotmc.org/" + SpigetUpdateAbstract.this.latestResourceInfo.file.url, !SpigetUpdateAbstract.this.latestResourceInfo.external);
                    } else {
                        callback.upToDate();
                    }
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(Main.getString("updater.failed"));
                }
            }
        });
    }
}

