/*
 * Decompiled with CFR 0.152.
 */
package me.bruno.login.manager;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import me.bruno.login.Main;
import me.bruno.login.manager.MySql;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LoginManager
extends MySql {
    private static LoginManager lm;
    private File configFile = new File(Main.getPlugin().getDataFolder(), "accounts.yml");
    private YamlConfiguration f = null;

    public LoginManager() {
        lm = this;
        if (!this.isMySql()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            try {
                config.save(this.configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.f = config;
        }
    }

    public String getPin(Player player) {
        if (this.isMySql()) {
            try {
                PreparedStatement s = con.prepareStatement("SELECT * FROM `pins` WHERE `player` = ?");
                s.setString(1, player.getUniqueId().toString());
                ResultSet rs = s.executeQuery();
                if (rs.next()) {
                    return rs.getString("pin");
                }
                return null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            return this.getFile().getString("users." + player.getUniqueId().toString() + ".pin");
        }
        return null;
    }

    public boolean isGen(Player player) {
        if (this.isMySql()) {
            try {
                PreparedStatement s = con.prepareStatement("SELECT * FROM `pins` WHERE `player` = ?");
                s.setString(1, player.getUniqueId().toString());
                ResultSet rs = s.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            return this.getFile().contains("users." + player.getUniqueId().toString() + ".pin");
        }
        return false;
    }

    public void genPin(Player player) {
        String[] str = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        String c = "";
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            String all = stringArray[n2];
            l.add(all);
            ++n2;
        }
        int i = 0;
        while (i < 10) {
            c = String.valueOf(c) + (String)l.get(new Random().nextInt(str.length));
            ++i;
        }
        if (this.isMySql()) {
            try {
                PreparedStatement s = con.prepareStatement("INSERT INTO `pins`(`player`, `pin`) VALUES (?,?)");
                s.setString(1, player.getUniqueId().toString());
                s.setString(2, c);
                s.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.getFile().set("users." + player.getUniqueId().toString() + ".pin", (Object)c);
            this.save();
        }
    }

    public String firstLogin(Player player) {
        if (!this.isMySql()) {
            String s = this.getFile().getString("users." + player.getUniqueId().toString() + ".firstlogin");
            return s;
        }
        try {
            PreparedStatement s = con.prepareStatement("SELECT * FROM dates WHERE player = " + player.getUniqueId().toString());
            ResultSet rs = s.executeQuery();
            if (rs.next()) {
                return rs.getString("first");
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String lastLogin(Player player) {
        if (!this.isMySql()) {
            String s = this.getFile().getString("users." + player.getUniqueId().toString() + ".lastlogin");
            return s;
        }
        try {
            PreparedStatement s = con.prepareStatement("SELECT * FROM dates WHERE player = " + player.getUniqueId().toString());
            ResultSet rs = s.executeQuery();
            if (rs.next()) {
                return rs.getString("last");
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void resetAccount(Player player) {
        if (this.isLogged(player)) {
            this.unLogin(player);
        }
        if (this.hasAccount(player)) {
            this.delete(player);
        }
    }

    public static LoginManager getManager() {
        return lm;
    }

    public boolean isMySql() {
        return Main.getPlugin().getConfig().getBoolean("mysql.enabled");
    }

    public YamlConfiguration getFile() {
        return this.f;
    }

    public void login(Player player) {
        if (this.isMySql()) {
            if (this.hasAccount(player)) {
                PreparedStatement s = null;
                try {
                    s = con.prepareStatement("INSERT INTO `login`(`player`) VALUES (?)");
                    s.setString(1, player.getUniqueId().toString());
                    s.executeUpdate();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    Date d = Date.from(Instant.now());
                    SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
                    s = con.prepareStatement("UPDATE dates SET last = ? WHERE player = ?");
                    s.setString(1, f.format(d));
                    s.setString(2, player.getUniqueId().toString());
                    s.executeQuery();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.hasAccount(player)) {
            this.getFile().set("users." + player.getUniqueId().toString() + ".logged", (Object)true);
            Date d = Date.from(Instant.now());
            SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
            this.getFile().set("users." + player.getUniqueId().toString() + ".lastlogin", (Object)f.format(d));
            this.save();
        }
    }

    private void save() {
        try {
            this.f.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void register(Player player, String password) {
        if (this.isMySql()) {
            if (!this.hasAccount(player)) {
                PreparedStatement s = null;
                try {
                    s = con.prepareStatement("INSERT INTO `accounts`(`player`, `password`) VALUES (?,?)");
                    s.setString(1, player.getUniqueId().toString());
                    s.setString(2, password);
                    s.executeUpdate();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    Date d = Date.from(Instant.now());
                    SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
                    s = con.prepareStatement("INSERT INTO dates(player, first, last) VALUES (?,?,?)");
                    s.setString(1, player.getUniqueId().toString());
                    s.setString(2, f.format(d));
                    s.setString(3, f.format(d));
                    s.executeQuery();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else if (!this.hasAccount(player)) {
            this.getFile().set("users." + player.getUniqueId().toString() + ".logged", (Object)true);
            this.getFile().set("users." + player.getUniqueId().toString() + ".registred", (Object)true);
            this.getFile().set("users." + player.getUniqueId().toString() + ".password", (Object)password);
            Date d = Date.from(Instant.now());
            SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
            this.getFile().set("users." + player.getUniqueId().toString() + ".firstlogin", (Object)f.format(d));
            this.getFile().set("users." + player.getUniqueId().toString() + ".lastlogin", (Object)f.format(d));
            this.save();
        }
    }

    public boolean isLogged(Player player) {
        if (this.isMySql()) {
            PreparedStatement s = null;
            try {
                s = con.prepareStatement("SELECT * FROM `login` WHERE `player` = ?");
                s.setString(1, player.getUniqueId().toString());
                ResultSet rs = s.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                return false;
            }
        }
        return this.getFile().getBoolean("users." + player.getUniqueId().toString() + ".logged");
    }

    public void unLogin(Player player) {
        if (this.isMySql()) {
            if (this.isLogged(player)) {
                PreparedStatement s = null;
                try {
                    s = con.prepareStatement("DELETE FROM `login` WHERE `player` = ?");
                    s.setString(1, player.getUniqueId().toString());
                    s.executeUpdate();
                    return;
                }
                catch (SQLException e) {
                    return;
                }
            }
        } else {
            this.getFile().set("users." + player.getUniqueId().toString() + ".logged", (Object)false);
            this.save();
        }
    }

    public boolean hasAccount(Player player) {
        if (this.isMySql()) {
            PreparedStatement s = null;
            try {
                s = con.prepareStatement("SELECT * FROM `accounts` WHERE `player` = ?");
                s.setString(1, player.getUniqueId().toString());
                ResultSet rs = s.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                return false;
            }
        }
        return this.getFile().contains("users." + player.getUniqueId().toString());
    }

    public void delete(Player player) {
        if (this.isMySql()) {
            if (this.hasAccount(player)) {
                this.unLogin(player);
                PreparedStatement s = null;
                try {
                    s = con.prepareStatement("DELETE FROM `accounts` WHERE `player` = ?");
                    s.setString(1, player.getUniqueId().toString());
                    s.executeQuery();
                }
                catch (SQLException sQLException) {}
            }
        } else {
            this.getFile().set("users." + player.getUniqueId().toString(), null);
            this.save();
        }
    }

    public void changePassword(Player player, String newPassword) {
        this.delete(player);
        this.register(player, newPassword);
    }

    public String getPassword(Player player) {
        if (this.isMySql()) {
            PreparedStatement s = null;
            if (this.hasAccount(player)) {
                try {
                    s = con.prepareStatement("SELECT * FROM `accounts` WHERE `player` = ?");
                    s.setString(1, player.getUniqueId().toString());
                    ResultSet rs = s.executeQuery();
                    if (rs.next()) {
                        return rs.getString("password");
                    }
                    return null;
                }
                catch (SQLException e) {
                    return null;
                }
            }
        } else {
            return this.getFile().getString("users." + player.getUniqueId().toString() + ".password");
        }
        this.save();
        return null;
    }
}

