/*
 * Decompiled with CFR 0.152.
 */
package me.bruno.login;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import me.bruno.login.events.Eventos;
import me.bruno.login.manager.LanguageManager;
import me.bruno.login.manager.LoginManager;
import me.bruno.login.manager.MySql;
import me.bruno.login.manager.SpigetUpdate;
import me.bruno.login.manager.UpdateCallback;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutTitle;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main plugin;
    private static File f;
    private static YamlConfiguration accounts;

    static {
        f = new File("accounts.yml");
        accounts = YamlConfiguration.loadConfiguration((File)f);
    }

    public static Main getPlugin() {
        return plugin;
    }

    public static String getString(String loc) {
        try {
            return new LanguageManager().getFileLanguage().getString("messages." + loc).replace("&", "\u00a7").replace("%line%", "\n");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onEnable() {
        plugin = this;
        try {
            new LanguageManager().saveFileLanguage();
            new LoginManager();
        }
        catch (FileNotFoundException e1) {
            this.getConfig().set("language", (Object)"pt-br");
            this.saveConfig();
            try {
                new LanguageManager().saveFileLanguage();
                new LoginManager();
                this.saveDefaultConfig();
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
        }
        if (this.getConfig().getBoolean("configuration.updaterEnabled")) {
            final SpigetUpdate updater = new SpigetUpdate((Plugin)this, 42077);
            updater.checkForUpdate(new UpdateCallback(){

                @Override
                public void updateAvailable(String newVersion, String downloadUrl, boolean canAutoDownload) {
                    Bukkit.getConsoleSender().sendMessage(Main.getString("updater.process.check"));
                    if (canAutoDownload) {
                        if (updater.downloadUpdate()) {
                            updater.downloadUpdate();
                            Bukkit.getConsoleSender().sendMessage(Main.getString("updater.success.updated").replace("%old-version%", Main.getPlugin().getDescription().getVersion().replace("v", "")).replace("%new-version%", updater.getLatestResourceInfo().latestVersion.name.replace("v", "").replace("[", "").replace("]", "")));
                        } else {
                            String reason = null;
                            if (updater.getFailReason() == SpigetUpdate.DownloadFailReason.EXTERNAL_DISALLOWED) {
                                reason = Main.getString("updater.reasons.external-disallowed");
                            } else if (updater.getFailReason() == SpigetUpdate.DownloadFailReason.NO_DOWNLOAD) {
                                reason = Main.getString("updater.reasons.no-download");
                            } else if (updater.getFailReason() == SpigetUpdate.DownloadFailReason.NO_PLUGIN_FILE) {
                                reason = Main.getString("updater.reasons.no-file");
                            } else if (updater.getFailReason() == SpigetUpdate.DownloadFailReason.NO_UPDATE) {
                                reason = Main.getString("updater.reasons.no-update");
                            } else if (updater.getFailReason() == SpigetUpdate.DownloadFailReason.NO_UPDATE_FOLDER) {
                                reason = Main.getString("updater.reasons.no-folder");
                            } else if (updater.getFailReason() == SpigetUpdate.DownloadFailReason.UNKNOWN) {
                                reason = Main.getString("updater.reasons.unknown");
                            }
                            Bukkit.getConsoleSender().sendMessage(Main.getString("updater.cannotUpdate").replace("%reason%", reason));
                        }
                    } else {
                        Bukkit.getConsoleSender().sendMessage(Main.getString("updater.no-available-update"));
                    }
                }

                @Override
                public void upToDate() {
                }
            });
        }
        this.c();
        this.e();
        Main.save();
        if (this.getConfig().getBoolean("mysql.enabled")) {
            MySql.open();
        }
        this.saveDefaultConfig();
    }

    public static YamlConfiguration getAccounts() {
        return accounts;
    }

    public static void save() {
        try {
            accounts.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        if (this.getConfig().getBoolean("mysql.enabled")) {
            MySql.close();
        }
    }

    private void c() {
        this.getCommand("register").setExecutor((CommandExecutor)new Eventos());
        this.getCommand("login").setExecutor((CommandExecutor)new Eventos());
        this.getCommand("changePassword").setExecutor((CommandExecutor)new Eventos());
        this.getCommand("setPassword").setExecutor((CommandExecutor)new Eventos());
        this.getCommand("pin").setExecutor((CommandExecutor)new Eventos());
    }

    private void e() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new Eventos(), (Plugin)this);
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeout) {
        IChatBaseComponent chatTitle = IChatBaseComponent.ChatSerializer.a((String)("{\"text\": \"" + title + "\"}"));
        IChatBaseComponent chatsubtitle = IChatBaseComponent.ChatSerializer.a((String)("{\"text\": \"" + subtitle + "\"}"));
        PacketPlayOutTitle t = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, chatTitle);
        PacketPlayOutTitle s = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, chatsubtitle);
        PacketPlayOutTitle length = new PacketPlayOutTitle(fadeIn * 20, stay * 20, fadeout * 20);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)t);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)s);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)length);
    }
}

