/*
 * Decompiled with CFR 0.152.
 */
package dev.wonkypigs.loginsystem.listeners;

import dev.wonkypigs.loginsystem.LoginSystem;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerJoinLeaveListener
implements Listener {
    private final LoginSystem plugin = (LoginSystem)LoginSystem.getPlugin(LoginSystem.class);

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        PersistentDataContainer pdata = player.getPersistentDataContainer();
        pdata.set(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING, (Object)"no");
        if (!pdata.has(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY)) {
            player.sendMessage(this.plugin.prefix + ChatColor.RED + "You do not have a password set. Type '/setpassword <password>' to set one.");
        } else {
            player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "You have a password set. Type '/login <password>' to login.");
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        PersistentDataContainer pdata = player.getPersistentDataContainer();
        if (!pdata.has(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY)) {
            e.setCancelled(true);
        } else if (((String)pdata.get(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING)).equalsIgnoreCase("no")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        PersistentDataContainer pdata = player.getPersistentDataContainer();
        if (!pdata.has(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY)) {
            e.setCancelled(true);
            player.sendMessage(this.plugin.prefix + ChatColor.RED + "You do not have a password set. Type '/setpassword <password>' to set one.");
        } else if (((String)pdata.get(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING)).equalsIgnoreCase("no")) {
            e.setCancelled(true);
            player.sendMessage(this.plugin.prefix + ChatColor.RED + "You are not logged in. Type '/login <password>' to login.");
        }
    }
}

