/*
 * Decompiled with CFR 0.152.
 */
package dev.wonkypigs.loginsystem.commands;

import dev.wonkypigs.loginsystem.LoginSystem;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LoginCommand
implements CommandExecutor {
    private final LoginSystem plugin = (LoginSystem)LoginSystem.getPlugin(LoginSystem.class);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            PersistentDataContainer pdata = player.getPersistentDataContainer();
            if (!pdata.has(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY)) {
                player.sendMessage(this.plugin.prefix + ChatColor.RED + "You do not have a password set. Type '/setpassword <password>' to set one.");
                return true;
            }
            if (!((String)pdata.get(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING)).equalsIgnoreCase("yes")) {
                if (args.length == 1) {
                    byte[] player_password;
                    byte[] salt = (byte[])pdata.get(new NamespacedKey((Plugin)this.plugin, "password_salt"), PersistentDataType.BYTE_ARRAY);
                    if (LoginCommand.checkPassword(salt, player_password = (byte[])pdata.get(new NamespacedKey((Plugin)this.plugin, "password"), PersistentDataType.BYTE_ARRAY), args[0])) {
                        pdata.set(new NamespacedKey((Plugin)this.plugin, "loggedin"), PersistentDataType.STRING, (Object)"yes");
                        player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "You have successfully logged in");
                    } else {
                        player.sendMessage(this.plugin.prefix + ChatColor.RED + "Incorrect password.");
                    }
                } else {
                    player.sendMessage(this.plugin.prefix + ChatColor.RED + "Usage: '/login <password>'");
                }
            } else {
                player.sendMessage(this.plugin.prefix + ChatColor.GREEN + "You are already logged in.");
            }
        } else {
            sender.sendMessage(this.plugin.prefix + ChatColor.RED + "Only players can use this command!");
        }
        return true;
    }

    public static boolean checkPassword(byte[] salt, byte[] hashed_pass, String arg_pass) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(salt);
        byte[] hashed_arg = md.digest(arg_pass.getBytes(StandardCharsets.UTF_8));
        return hashed_arg.equals(hashed_pass);
    }
}

