/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.misc.Reflection;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.AutoSavePolicy;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.Configuration;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.mapping.ConfigHeader;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.mapping.ConfigOption;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class InternalMapper {
    private final Map<Class<?>, SettingsHolder> holders = Maps.newConcurrentMap();

    public void registerSettingsClass(Class<?> settingsClass, Configuration config, AutoSavePolicy autoSave) {
        SettingsHolder holder = new SettingsHolder(config, autoSave, settingsClass);
        this.holders.put(settingsClass, holder);
    }

    public void loadSettings(Class<?> byClass, boolean writeDefaults) {
        SettingsHolder holder = this.holders.get(byClass);
        if (holder == null) {
            throw new IllegalArgumentException("Specified settings not registered");
        }
        holder.load(writeDefaults);
    }

    public void saveSettings(Class<?> byClass) {
        SettingsHolder holder = this.holders.get(byClass);
        if (holder == null) {
            throw new IllegalArgumentException("Specified settings not registered");
        }
        holder.save();
    }

    public void shutdown() {
        for (SettingsHolder holder : this.holders.values()) {
            if (holder.getAutoSave() != AutoSavePolicy.ON_SHUTDOWN) continue;
            holder.save();
        }
    }

    protected static class SettingsHolder {
        private List<ConfigOption> options = Lists.newArrayList();
        private final Configuration config;
        private final AutoSavePolicy autoSave;

        public SettingsHolder(Configuration config, AutoSavePolicy autoSave, Class<?> settingsClass) {
            this.config = config;
            this.autoSave = autoSave;
            this.registerOptions(settingsClass);
        }

        public AutoSavePolicy getAutoSave() {
            return this.autoSave;
        }

        private void registerOptions(Class<?> settingsClass) {
            String seperator = Character.toString(this.config.options().pathSeparator());
            for (Field field : settingsClass.getFields()) {
                ConfigOption value;
                if (!ConfigOption.class.isAssignableFrom(field.getType()) || (value = Reflection.getFieldValue(field, null, ConfigOption.class)) == null) continue;
                value.setHolder(this);
                this.options.add(value);
                ConfigHeader header = field.getAnnotation(ConfigHeader.class);
                if (header == null) continue;
                String path = header.path().isEmpty() ? value.getPath(seperator) : header.path();
                this.config.header(path, header.value());
            }
        }

        public void load(boolean writeDefaults) {
            this.config.reload();
            for (ConfigOption option : this.options) {
                option.loadFromConfig((ConfigurationSection)this.config);
            }
            if (writeDefaults) {
                for (String key : this.config.getKeys(false)) {
                    this.config.set(key, null);
                }
                this.save();
            }
        }

        public void save() {
            for (ConfigOption option : this.options) {
                option.saveToConfig((ConfigurationSection)this.config);
            }
            this.config.save();
        }
    }
}

