/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.database;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.database.AsyncResult;
import com.lenis0012.bukkit.loginsecurity.database.SQLConsumer;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerInventory;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class InventoryRepository {
    private final LoginSecurity loginSecurity;
    private final DataSource dataSource;

    public InventoryRepository(LoginSecurity loginSecurity, DataSource dataSource) {
        this.loginSecurity = loginSecurity;
        this.dataSource = dataSource;
    }

    public void insert(PlayerProfile profile, PlayerInventory inventory, Consumer<AsyncResult<PlayerInventory>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                this.insertBlocking(profile, inventory);
                this.resolveResult(callback, inventory);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    public void insertBlocking(PlayerProfile profile, PlayerInventory inventory) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO ls_inventories(helmet, chestplate, leggings, boots, off_hand, contents) VALUES (?,?,?,?,?,?);", 1);){
                this.prepareInsert(statement, inventory);
                statement.executeUpdate();
                try (ResultSet keys = statement.getGeneratedKeys();){
                    if (!keys.next()) {
                        throw new RuntimeException("No keys were returned after insert");
                    }
                    inventory.setId(keys.getInt(1));
                }
            }
            profile.setInventoryId(inventory.getId());
            statement = connection.prepareStatement("UPDATE ls_players SET inventory_id=? WHERE id=?;");
            try {
                statement.setInt(1, inventory.getId());
                statement.setInt(2, profile.getId());
                if (statement.executeUpdate() < 1) {
                    this.loginSecurity.getLogger().log(Level.WARNING, "Failed to set location id in profile");
                    throw new SQLException("Failed set location id in profile");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public void findById(int id, Consumer<AsyncResult<PlayerInventory>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                PlayerInventory inventory = this.findByIdBlocking(id);
                this.resolveResult(callback, inventory);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public PlayerInventory findByIdBlocking(int id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void iterateAllBlocking(SQLConsumer<PlayerInventory> consumer) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery("SELECT * FROM ls_inventories;");){
            while (result.next()) {
                consumer.accept(this.parseResultSet(result));
            }
        }
    }

    public void batchInsert(SQLConsumer<SQLConsumer<PlayerInventory>> callback) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO ls_inventories(helmet, chestplate, leggings, boots, off_hand, contents) VALUES (?,?,?,?,?,?);");){
            AtomicInteger currentBatchSize = new AtomicInteger();
            callback.accept(inventory -> {
                this.prepareInsert(statement, (PlayerInventory)inventory);
                statement.addBatch();
                if (currentBatchSize.incrementAndGet() >= 1000) {
                    statement.executeBatch();
                    currentBatchSize.set(0);
                }
            });
            if (currentBatchSize.get() > 0) {
                statement.executeBatch();
            }
        }
    }

    private void prepareInsert(PreparedStatement statement, PlayerInventory inventory) throws SQLException {
        statement.setString(1, inventory.getHelmet());
        statement.setString(2, inventory.getChestplate());
        statement.setString(3, inventory.getLeggings());
        statement.setString(4, inventory.getBoots());
        statement.setString(5, inventory.getOffHand());
        statement.setString(6, inventory.getContents());
    }

    private PlayerInventory parseResultSet(ResultSet result) throws SQLException {
        PlayerInventory inventory = new PlayerInventory();
        inventory.setId(result.getInt("id"));
        inventory.setHelmet(result.getString("helmet"));
        inventory.setChestplate(result.getString("chestplate"));
        inventory.setLeggings(result.getString("leggings"));
        inventory.setBoots(result.getString("boots"));
        inventory.setOffHand(result.getString("off_hand"));
        inventory.setContents(result.getString("contents"));
        return inventory;
    }

    private <T> void resolveResult(Consumer<AsyncResult<T>> callback, T result) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> callback.accept(new AsyncResult<Object>(true, result, null)));
    }

    private <T> void resolveError(Consumer<AsyncResult<T>> callback, Exception error) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> callback.accept(new AsyncResult<Object>(false, null, error)));
    }
}

