/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.language;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.Module;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageAPI;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.modules.language.TranslatedMessage;
import com.lenis0012.bukkit.loginsecurity.modules.language.Translation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;

public class LanguageModule
extends Module<LoginSecurity> {
    private Translation translation;
    private LanguageAPI languageAPI;

    public LanguageModule(LoginSecurity plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        this.logger().log(Level.INFO, "Loading base translations from \"en_us\"");
        Translation base = this.byResource("en_us", null);
        this.languageAPI = new LanguageAPI();
        String languageCode = LoginSecurity.getConfiguration().getLanguage();
        this.logger().log(Level.INFO, "Loading specified translations from \"" + languageCode + "\"");
        File file = new File(((LoginSecurity)this.plugin).getDataFolder(), languageCode + ".json");
        if (languageCode.equalsIgnoreCase("en_us") || languageCode.equalsIgnoreCase("default")) {
            this.translation = base;
        } else if (file.exists()) {
            this.translation = this.byFile(file, base);
        } else {
            try {
                this.translation = this.byResource(languageCode, base);
            }
            catch (Exception e) {
                this.logger().log(Level.WARNING, "Can't find translation for " + languageCode + ". Are you upt to date?");
                this.translation = base;
            }
        }
    }

    @Override
    public void disable() {
    }

    private Translation byFile(File file, Translation fallback) {
        String name = file.getName().split("\\.")[0];
        try {
            FileInputStream input = new FileInputStream(file);
            return new Translation(fallback, new InputStreamReader((InputStream)input, StandardCharsets.UTF_8), name);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read internal language file", e);
        }
    }

    private Translation byResource(String name, Translation fallback) {
        try {
            InputStream input = ((LoginSecurity)this.plugin).getResource("lang/" + name + ".json");
            return new Translation(fallback, new InputStreamReader(input, StandardCharsets.UTF_8), name);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read internal language file", e);
        }
    }

    public Translation getTranslation() {
        return this.translation;
    }

    public TranslatedMessage translate(LanguageKeys key) {
        return this.translate(key.toString());
    }

    public TranslatedMessage translate(String rawKey) {
        return this.translation.translate(rawKey);
    }
}

