/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.general;

import com.google.common.collect.Lists;
import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.LoginSecurityConfig;
import com.lenis0012.bukkit.loginsecurity.modules.general.GeneralModule;
import com.lenis0012.bukkit.loginsecurity.modules.general.LocationMode;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerLocation;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import com.lenis0012.bukkit.loginsecurity.util.MetaData;
import com.lenis0012.bukkit.loginsecurity.util.UserIdMode;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerListener
implements Listener {
    private List<String> ALLOWED_COMMANDS = Lists.newArrayList((Object[])new String[]{"/login ", "/register "});
    private GeneralModule general;

    public PlayerListener(GeneralModule general) {
        this.general = general;
    }

    @EventHandler
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        PlayerSession session;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(event.getName()) || !(session = LoginSecurity.getSessionManager().getPlayerSession(player)).isAuthorized()) continue;
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            event.setKickMessage("[LoginSecurity] " + LoginSecurity.translate(LanguageKeys.KICK_ALREADY_ONLINE));
            return;
        }
        String name = event.getName();
        LoginSecurityConfig config = LoginSecurity.getConfiguration();
        if (config.isFilterSpecialChars() && !name.replaceAll("[^a-zA-Z0-9_]", "").equals(name)) {
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            event.setKickMessage("[LoginSecurity] " + LoginSecurity.translate(LanguageKeys.KICK_USERNAME_CHARS));
            return;
        }
        if (name.length() < config.getUsernameMinLength() || name.length() > config.getUsernameMaxLength()) {
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            event.setKickMessage("[LoginSecurity] " + LoginSecurity.translate(LanguageKeys.KICK_USERNAME_LENGTH).param("min", config.getUsernameMinLength()).param("max", config.getPasswordMaxLength()));
            return;
        }
        session = LoginSecurity.getSessionManager().preloadSession(event.getName(), event.getUniqueId());
        if (LoginSecurity.getConfiguration().isMatchUsernameExact() && session.getProfile().getUniqueIdMode() == UserIdMode.OFFLINE && session.getProfile().getLastName() != null && !event.getName().equals(session.getProfile().getLastName())) {
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            event.setKickMessage("[LoginSecurity] " + LoginSecurity.translate(LanguageKeys.KICK_USERNAME_REGISTERED).param("username", session.getProfile().getLastName()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        LoginSecurity.getSessionManager().onPlayerLogout(event.getPlayer());
        MetaData.unset(event.getPlayer(), "ls_login_tries");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        PlayerProfile profile = session.getProfile();
        if (profile.getLastName() == null || !player.getName().equals(profile.getLastName())) {
            profile.setLastName(player.getName());
            if (session.isRegistered()) {
                session.saveProfileAsync();
            }
        }
        if (session.isAuthorized() || !session.isRegistered()) {
            return;
        }
        LoginSecurityConfig config = LoginSecurity.getConfiguration();
        if (config.isBlindness()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 1));
        }
        if (profile.getLoginLocationId() == null && !player.isDead()) {
            Location origin = player.getLocation().clone();
            if (this.general.getLocationMode() == LocationMode.SPAWN) {
                player.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
                PlayerLocation serializedLocation = new PlayerLocation(origin);
                LoginSecurity.getDatastore().getLocationRepository().insertLoginLocation(profile, serializedLocation, result -> {
                    if (!result.success()) {
                        LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to save player location", result.error());
                        player.teleport(origin);
                    }
                });
            }
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (this.isInvalidPlayer(event.getPlayer())) {
            return;
        }
        Player player = (Player)event.getPlayer();
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.defaultEventAction((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        LoginSecurityConfig config = LoginSecurity.getConfiguration();
        if (config.isUseCommandShortcut()) {
            if (event.getMessage().toLowerCase().startsWith(config.getLoginCommandShortcut() + " ")) {
                event.setMessage("/login " + event.getMessage().substring(config.getLoginCommandShortcut().length() + 1));
            } else if (event.getMessage().toLowerCase().startsWith(config.getRegisterCommandShortcut() + " ")) {
                event.setMessage("/register " + event.getMessage().substring(config.getRegisterCommandShortcut().length() + 1));
            } else if (event.getMessage().equalsIgnoreCase(config.getLoginCommandShortcut())) {
                event.setMessage("/login");
            } else if (event.getMessage().equalsIgnoreCase(config.getRegisterCommandShortcut())) {
                event.setMessage("/register");
            }
        }
        if (session.isAuthorized()) {
            return;
        }
        String message = event.getMessage().toLowerCase();
        for (String cmd : this.ALLOWED_COMMANDS) {
            if (!message.startsWith(cmd)) continue;
            return;
        }
        if (message.startsWith("/f")) {
            event.setMessage("/LOGIN_SECURITY_FACTION_REPLACEMENT_FIX");
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.defaultEventAction((PlayerEvent)event);
    }

    @EventHandler
    public void on(EntityCombustEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() != to.getBlockX() || from.getBlockZ() != to.getBlockZ()) {
            event.setTo(event.getFrom());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(InventoryClickEvent event) {
        this.defaultEventAction((InventoryInteractEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(InventoryDragEvent event) {
        this.defaultEventAction((InventoryInteractEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.defaultEventAction((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        this.defaultEventAction((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Player player = (Player)event.getEntity();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTarget(EntityTargetEvent event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getTarget();
        if (!player.isOnline()) {
            return;
        }
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    private void defaultEventAction(InventoryInteractEvent event) {
        if (!(event instanceof Cancellable)) {
            throw new IllegalArgumentException("Event cannot be cancelled!");
        }
        Player player = (Player)event.getWhoClicked();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        event.setCancelled(true);
    }

    private void defaultEventAction(PlayerEvent event) {
        if (!(event instanceof Cancellable)) {
            throw new IllegalArgumentException("Event cannot be cancelled!");
        }
        Player player = event.getPlayer();
        if (this.isInvalidPlayer((HumanEntity)player)) {
            return;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return;
        }
        ((Cancellable)event).setCancelled(true);
    }

    private boolean isInvalidPlayer(HumanEntity human) {
        if (!(human instanceof Player)) {
            return true;
        }
        Player player = (Player)human;
        return player.hasMetadata("NPC") || !player.isOnline();
    }
}

