/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils;

import com.google.common.collect.Lists;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.PluginHolder;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;

public abstract class Module<T extends PluginHolder> {
    protected T plugin;
    protected boolean enabled;
    boolean local;

    public Module(T plugin) {
        this.plugin = plugin;
    }

    public abstract void enable();

    public abstract void disable();

    public void reload() {
    }

    public List<Class<? extends Module>> getRequiredModules() {
        return Lists.newArrayList();
    }

    protected void register(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, this.plugin);
    }

    protected void register(CommandExecutor command, String ... cmds) {
        for (String cmd : cmds) {
            this.plugin.getCommand(cmd).setExecutor(command);
        }
    }

    protected Logger logger() {
        return this.plugin.getLogger();
    }
}

