/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.captcha;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.Module;
import com.lenis0012.bukkit.loginsecurity.modules.captcha.CaptchaRenderer;
import com.lenis0012.bukkit.loginsecurity.util.MetaData;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class CaptchaManager
extends Module<LoginSecurity>
implements Listener {
    private final Random random = new Random();
    private MapView view;
    private Method setMapIdMethod;
    private int mapViewId;
    private boolean failedToLoadMapView = false;

    public CaptchaManager(LoginSecurity plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        this.view = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
        for (MapRenderer renderer : this.view.getRenderers()) {
            this.view.removeRenderer(renderer);
        }
        this.view.addRenderer((MapRenderer)new CaptchaRenderer());
        this.register(this);
        try {
            this.setMapIdMethod = MapMeta.class.getMethod("setMapId", Integer.TYPE);
            LoginSecurity.getInstance().getLogger().log(Level.INFO, "Using 1.12+ map captcha renderer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Method method : MapView.class.getMethods()) {
                if (!method.getName().equals("getId")) continue;
                Object rawMapId = method.invoke((Object)this.view, new Object[0]);
                if (rawMapId instanceof Integer) {
                    this.mapViewId = (Integer)rawMapId;
                    continue;
                }
                if (rawMapId instanceof Short) {
                    this.mapViewId = ((Short)rawMapId).shortValue();
                    continue;
                }
                throw new RuntimeException("Unknown map ID type " + rawMapId.getClass().getName());
            }
        }
        catch (Exception e) {
            LoginSecurity.getInstance().getLogger().log(Level.WARNING, "Failed to load captcha map", e);
        }
    }

    @Override
    public void disable() {
    }

    public void giveMapItem(Player player, Runnable callback) {
        if (this.failedToLoadMapView) {
            callback.run();
            return;
        }
        ItemStack item = new ItemStack(Material.MAP, 1, (short)this.mapViewId);
        ItemMeta meta = item.getItemMeta();
        if (this.setMapIdMethod != null) {
            try {
                this.setMapIdMethod.invoke((Object)meta, this.mapViewId);
            }
            catch (Exception e) {
                LoginSecurity.getInstance().getLogger().log(Level.WARNING, "Failed to set map", e);
            }
        }
        meta.setDisplayName("Captcha [Enter In Chat]");
        item.setItemMeta(meta);
        MetaData.set(player, "ls_captcha_callback", callback);
        MetaData.set(player, "ls_captcha_value", this.randomCaptcha(5));
        player.setItemInHand(item);
        this.view.setCenterX(player.getLocation().getBlockX());
        this.view.setCenterZ(player.getLocation().getBlockZ());
        player.sendMap(this.view);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        MetaData.unset(player, "ls_captcha_value");
        MetaData.unset(player, "ls_captcha_callback");
        MetaData.unset(player, "ls_captcha_set");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        if (!MetaData.has(player, "ls_captcha_callback")) {
            return;
        }
        String captcha = MetaData.get(player, "ls_captcha_value", String.class);
        if (!event.getMessage().trim().equalsIgnoreCase(captcha)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.kickPlayer("Wrong captcha! Please try again.");
                }
            });
            return;
        }
        Runnable callback = MetaData.get(player, "ls_captcha_callback", Runnable.class);
        MetaData.unset(player, "ls_captcha_callback");
        MetaData.unset(player, "ls_captcha_value");
        player.getInventory().remove(Material.MAP);
        callback.run();
    }

    private String randomCaptcha(int length) {
        String sheet = "ABCDEFHIJKLMNOPQRSTUVWXYZ123456789";
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("ABCDEFHIJKLMNOPQRSTUVWXYZ123456789".charAt(this.random.nextInt("ABCDEFHIJKLMNOPQRSTUVWXYZ123456789".length())));
        }
        return builder.toString();
    }
}

