/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.updater.spigot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.BaseUpdater;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.ReleaseType;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.Version;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SpigotUpdater
extends BaseUpdater {
    private final String versionURL;

    public SpigotUpdater(Plugin plugin, File pluginFile, String versionURL, boolean enabled) {
        super(plugin, pluginFile);
        this.enabled = enabled;
        this.versionURL = versionURL;
        this.loadGravityFile(false);
    }

    @Override
    protected void read() {
        JsonElement json = this.readJsonFromURL(this.versionURL, false);
        if (json == null) {
            return;
        }
        JsonObject version = json.getAsJsonObject();
        if (version.has("release")) {
            version = this.readChannel(version);
        }
        String name = version.get("name").getAsString();
        ReleaseType type = ReleaseType.valueOf(version.get("type").getAsString().toUpperCase());
        String serverVersion = version.get("gameVersion").getAsString();
        String downloadURL = version.get("downloadURL").getAsString();
        this.newVersion = new Version(name, type, serverVersion, downloadURL);
        this.isOutdated = !this.compareVersions(this.currentVersion, name);
    }

    @Override
    public boolean isBukkitUpdater() {
        return false;
    }

    @Override
    public String downloadVersion() {
        String result = super.downloadVersion();
        if (result == null) {
            this.readChangelog(new File(Bukkit.getUpdateFolderFile(), this.pluginFile.getName()));
        }
        return result;
    }

    private JsonObject readChannel(JsonObject versions) {
        JsonObject latest = null;
        String newest = null;
        for (int i = ReleaseType.RELEASE.ordinal(); i >= this.channel.ordinal(); --i) {
            String base = ReleaseType.values()[i].toString().toLowerCase();
            if (!versions.has(base)) continue;
            JsonObject version = versions.get(base).getAsJsonObject();
            String name = version.get("name").getAsString();
            if (latest != null && !this.compareVersions(newest, name)) continue;
            latest = version;
            newest = name;
        }
        return latest;
    }

    private void readChangelog(File file) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setAuthor("lenis0012");
        meta.setTitle(this.currentVersion + " Changelog");
        JsonObject json = this.readJsonFromJar(file, "changelog.json");
        if (json == null || !json.get("version").getAsString().equalsIgnoreCase(this.newVersion.getName())) {
            return;
        }
        JsonArray pages = json.get("data").getAsJsonArray();
        for (int i = 0; i < pages.size(); ++i) {
            JsonArray lines = pages.get(i).getAsJsonArray();
            StringBuilder page = new StringBuilder();
            for (int j = 0; j < lines.size(); ++j) {
                page.append(lines.get(j).getAsString()).append('\n');
            }
            page.setLength(page.length() - 1);
            meta.addPage(new String[]{page.toString()});
        }
        book.setItemMeta((ItemMeta)meta);
        this.changelog = book;
    }
}

