/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.updater.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.ReleaseType;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.Updater;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class BaseUpdater
implements Updater {
    private static final long UPDATE_CACHE = TimeUnit.HOURS.toMillis(3L);
    protected final Plugin plugin;
    protected final JsonParser jsonParser;
    protected final File pluginFile;
    protected String currentVersion;
    protected boolean snapshot;
    protected boolean enabled;
    protected String apiKey;
    protected Version newVersion = null;
    protected boolean isOutdated = false;
    protected long nextUpdateCheck = 0L;
    protected ItemStack changelog;
    protected ReleaseType channel = ReleaseType.RELEASE;

    public BaseUpdater(Plugin plugin, File pluginFile) {
        this.plugin = plugin;
        this.jsonParser = new JsonParser();
        this.pluginFile = pluginFile;
        this.currentVersion = plugin.getDescription().getVersion();
        this.snapshot = this.currentVersion.contains("SNAPSHOT");
    }

    @Override
    public ReleaseType getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(ReleaseType channel) {
        this.channel = channel;
    }

    @Override
    public boolean hasUpdate() {
        if (!this.enabled) {
            return false;
        }
        if (this.nextUpdateCheck < System.currentTimeMillis()) {
            this.nextUpdateCheck = System.currentTimeMillis() + UPDATE_CACHE;
            this.read();
        }
        return !this.isOutdated;
    }

    @Override
    public Version getNewVersion() {
        return this.newVersion;
    }

    @Override
    public ItemStack getChangelog() {
        return this.changelog;
    }

    @Override
    public String downloadVersion() {
        if (this.newVersion == null) {
            return "Updater is disabled, enable in config.";
        }
        Bukkit.getUpdateFolderFile().mkdir();
        File destination = new File(Bukkit.getUpdateFolderFile(), this.pluginFile.getName());
        try {
            this.download(this.newVersion.getDownloadURL(), destination);
            this.currentVersion = this.newVersion.getName();
            return null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    protected abstract void read();

    protected void loadGravityFile(boolean allSettings) {
        File dir = new File(this.plugin.getDataFolder().getParentFile(), "Updater");
        File file = new File(dir, "config.yml");
        if (!file.exists()) {
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            config.load(file);
            String key = config.getString("api-key");
            if (key != null && !key.equals("PUT_API_KEY_HERE")) {
                this.apiKey = key;
            }
            if (allSettings) {
                this.enabled = !config.getBoolean("disable", false);
            }
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Error while reading gravity updater config", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonObject readJsonFromJar(File archive, String fileName) {
        JarFile jarFile = null;
        try {
            String line;
            jarFile = new JarFile(archive);
            InputStream input = jarFile.getInputStream(jarFile.getEntry(fileName));
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JsonObject jsonObject = this.jsonParser.parse(builder.toString()).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException e) {
            this.log(Level.WARNING, "Failed to read json from jar file", e);
            JsonObject jsonObject = null;
            return jsonObject;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonElement readJsonFromURL(String downloadURL, boolean withApiKey) {
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(downloadURL);
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            connection.addRequestProperty("User-Agent", this.getClass().getSimpleName() + "/v1 (by lenis0012)");
            if (this.apiKey != null && withApiKey) {
                connection.addRequestProperty("X-API-Key", this.apiKey);
            }
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JsonElement jsonElement = this.jsonParser.parse(builder.toString());
            return jsonElement;
        }
        catch (IOException e) {
            this.log(Level.WARNING, "Failed to read json from url " + downloadURL);
            JsonElement jsonElement = null;
            return jsonElement;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(String downloadURL, File destination) throws IOException {
        this.log(Level.INFO, "Downloading file " + destination.getName() + "...");
        URL url = new URL(downloadURL);
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int length;
            input = url.openStream();
            output = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((length = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, length);
            }
            this.log(Level.INFO, "Download complete!");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void log(Level level, String message) {
        this.plugin.getLogger().log(level, message);
    }

    protected void log(Level level, String message, Throwable error) {
        this.plugin.getLogger().log(level, message, error);
    }

    protected boolean compareVersions(String oldVersion, String newVersion) {
        int oldId = this.matchLength(oldVersion, newVersion);
        int newId = this.matchLength(newVersion, oldVersion);
        return this.snapshot ? newId >= oldId : newId > oldId;
    }

    private int matchLength(String a, String b) {
        a = a.replaceAll("[^0-9]", "");
        b = b.replaceAll("[^0-9]", "");
        while (a.length() < b.length()) {
            a = a + "0";
        }
        return Integer.parseInt(a);
    }
}

