/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.packets;

import com.google.common.collect.Maps;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.Module;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.PluginHolder;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.misc.Reflection;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.packets.Packet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PacketModule
extends Module {
    private Method GET_HANDLE;
    private Field PLAYER_CONNECTION;
    private Method SEND_PACKET;
    private final Map<String, Reflection.ClassReflection> packetReflectionMap = Maps.newConcurrentMap();

    public PacketModule(PluginHolder plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        this.GET_HANDLE = Reflection.getCBMethod("entity.CraftPlayer", "getHandle", new Class[0]);
        this.PLAYER_CONNECTION = Reflection.getNMSField("EntityPlayer", "playerConnection");
        this.SEND_PACKET = Reflection.getNMSMethod("PlayerConnection", "sendPacket", Reflection.getNMSClass("Packet"));
    }

    @Override
    public void disable() {
    }

    public Packet createPacket(String name) {
        Reflection.ClassReflection reflection = this.packetReflectionMap.get(name);
        if (reflection == null) {
            reflection = new Reflection.ClassReflection(Reflection.getNMSClass(name));
            this.packetReflectionMap.put(name, reflection);
        }
        Object instance = reflection.newInstance();
        return new Packet(reflection, instance);
    }

    public void sendPacket(Player player, Packet packet) {
        Object entityPlayer = Reflection.invokeMethod(this.GET_HANDLE, player, new Object[0]);
        Object playerConnection = Reflection.getFieldValue(this.PLAYER_CONNECTION, entityPlayer);
        Reflection.invokeMethod(this.SEND_PACKET, playerConnection, packet.getHandle());
    }

    public void broadcastPacket(World world, Packet packet) {
        for (Player player : world.getPlayers()) {
            this.sendPacket(player, packet);
        }
    }
}

