/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.database;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.database.AsyncResult;
import com.lenis0012.bukkit.loginsecurity.database.SQLConsumer;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import com.lenis0012.bukkit.loginsecurity.util.UserIdMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ProfileRepository {
    private final LoginSecurity loginSecurity;
    private final DataSource dataSource;

    public ProfileRepository(LoginSecurity loginSecurity, DataSource dataSource) {
        this.loginSecurity = loginSecurity;
        this.dataSource = dataSource;
    }

    public void insert(PlayerProfile profile, Consumer<AsyncResult<PlayerProfile>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                this.insertBlocking(profile);
                this.resolveResult(callback, profile);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    public void insertBlocking(PlayerProfile profile) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO ls_players(uuid_mode,unique_user_id,last_name,ip_address,password,hashing_algorithm,location_id,inventory_id,last_login,registration_date,optlock) VALUES(?,?,?,?,?,?,?,?,?,?,?);", 1);){
            this.prepareInsert(statement, profile);
            statement.executeUpdate();
            try (ResultSet keys = statement.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No keys were returned after insert");
                }
                profile.setId(keys.getInt(1));
            }
        }
    }

    public void update(PlayerProfile profile, Consumer<AsyncResult<PlayerProfile>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                this.updateBlocking(profile);
                this.resolveResult(callback, profile);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    public void updateBlocking(PlayerProfile profile) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE ls_players SET last_name=?,ip_address=?,password=?,hashing_algorithm=?,location_id=?,inventory_id=?,last_login=?,optlock=? WHERE id=?;");){
            this.prepareUpdate(statement, profile);
            statement.executeUpdate();
        }
    }

    public void delete(PlayerProfile profile, Consumer<AsyncResult<PlayerProfile>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                this.deleteBlocking(profile);
                this.resolveResult(callback, profile);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    public void deleteBlocking(PlayerProfile profile) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("DELETE FROM ls_players WHERE id=?;");){
            statement.setInt(1, profile.getId());
            statement.executeUpdate();
        }
    }

    public void findByUniqueId(UUID unqiueId, Consumer<AsyncResult<PlayerProfile>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                PlayerProfile profile = this.findByUniqueUserIdBlocking(unqiueId);
                this.resolveResult(callback, profile);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public PlayerProfile findByUniqueUserIdBlocking(UUID uniqueId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void findByLastName(String lastName, Consumer<AsyncResult<PlayerProfile>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.loginSecurity, () -> {
            try {
                PlayerProfile profile = this.findByLastNameBlocking(lastName);
                this.resolveResult(callback, profile);
            }
            catch (SQLException e) {
                this.resolveError(callback, e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public PlayerProfile findByLastNameBlocking(String lastName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void iterateAllBlocking(SQLConsumer<PlayerProfile> consumer) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery("SELECT * FROM ls_players;");){
            while (result.next()) {
                consumer.accept(this.parseResultSet(result));
            }
        }
    }

    public void batchInsert(SQLConsumer<SQLConsumer<PlayerProfile>> callback) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO ls_players(uuid_mode,unique_user_id,last_name,ip_address,password,hashing_algorithm,location_id,inventory_id,last_login,registration_date,optlock) VALUES(?,?,?,?,?,?,?,?,?,?,?);");){
            AtomicInteger currentBatchSize = new AtomicInteger();
            callback.accept(profile -> {
                this.prepareInsert(statement, (PlayerProfile)profile);
                statement.addBatch();
                if (currentBatchSize.incrementAndGet() >= 1000) {
                    statement.executeBatch();
                    currentBatchSize.set(0);
                }
            });
            if (currentBatchSize.get() > 0) {
                statement.executeBatch();
            }
        }
    }

    private void prepareInsert(PreparedStatement statement, PlayerProfile profile) throws SQLException {
        statement.setString(1, profile.getUniqueIdMode().getId());
        statement.setString(2, profile.getUniqueUserId());
        statement.setString(3, profile.getLastName());
        statement.setString(4, profile.getIpAddress());
        statement.setString(5, profile.getPassword());
        statement.setInt(6, profile.getHashingAlgorithm());
        if (profile.getLoginLocationId() == null) {
            statement.setNull(7, 4);
        } else {
            statement.setInt(7, profile.getLoginLocationId());
        }
        if (profile.getInventoryId() == null) {
            statement.setNull(8, 4);
        } else {
            statement.setInt(8, profile.getInventoryId());
        }
        statement.setTimestamp(9, Timestamp.from(Instant.now()));
        statement.setDate(10, new Date(System.currentTimeMillis()));
        statement.setLong(11, 1L);
    }

    private void prepareUpdate(PreparedStatement statement, PlayerProfile profile) throws SQLException {
        statement.setString(1, profile.getLastName());
        statement.setString(2, profile.getIpAddress());
        statement.setString(3, profile.getPassword());
        statement.setInt(4, profile.getHashingAlgorithm());
        if (profile.getLoginLocationId() == null) {
            statement.setNull(5, 4);
        } else {
            statement.setInt(5, profile.getLoginLocationId());
        }
        if (profile.getInventoryId() == null) {
            statement.setNull(6, 4);
        } else {
            statement.setInt(6, profile.getInventoryId());
        }
        statement.setTimestamp(7, Timestamp.from(Instant.now()));
        statement.setLong(8, profile.getVersion() + 1L);
        statement.setInt(9, profile.getId());
    }

    private PlayerProfile parseResultSet(ResultSet result) throws SQLException {
        PlayerProfile profile = new PlayerProfile();
        profile.setId(result.getInt("id"));
        profile.setUniqueIdMode(UserIdMode.fromId(result.getString("uuid_mode")));
        profile.setUniqueUserId(result.getString("unique_user_id"));
        profile.setLastName(result.getString("last_name"));
        profile.setIpAddress(result.getString("ip_address"));
        profile.setPassword(result.getString("password"));
        profile.setHashingAlgorithm(result.getInt("hashing_algorithm"));
        profile.setLoginLocationId((Integer)result.getObject("location_id"));
        profile.setInventoryId((Integer)result.getObject("inventory_id"));
        profile.setLastLogin(result.getTimestamp("last_login"));
        profile.setRegistrationDate(result.getDate("registration_date"));
        profile.setVersion(result.getLong("optlock"));
        return profile;
    }

    private <T> void resolveResult(Consumer<AsyncResult<T>> callback, T result) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> callback.accept(new AsyncResult<Object>(true, result, null)));
    }

    private <T> void resolveError(Consumer<AsyncResult<T>> callback, Exception error) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> callback.accept(new AsyncResult<Object>(false, null, error)));
    }
}

