/*
 * Decompiled with CFR 0.152.
 */
package net.castegaming.plugins.LoginPremium.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.castegaming.plugins.LoginPremium.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Title {
    private static Class<?> packetTitle;
    private static Class<?> packetActions;
    private static Class<?> nmsChatSerializer;
    private static Class<?> chatBaseComponent;
    private String title = "";
    private ChatColor titleColor = ChatColor.WHITE;
    private String subtitle = "";
    private ChatColor subtitleColor = ChatColor.WHITE;
    private int fadeInTime = -1;
    private int stayTime = -1;
    private int fadeOutTime = -1;
    private boolean ticks = true;
    private static final Map<Class<?>, Class<?>> CORRESPONDING_TYPES;

    static {
        Title.loadClasses();
        CORRESPONDING_TYPES = new HashMap();
    }

    public Title(String title) {
        this.title = title;
    }

    public Title(String title, String subtitle) {
        this.title = title;
        this.subtitle = subtitle;
    }

    public Title(Title title) {
        this.title = title.title;
        this.subtitle = title.subtitle;
        this.titleColor = title.titleColor;
        this.subtitleColor = title.subtitleColor;
        this.fadeInTime = title.fadeInTime;
        this.fadeOutTime = title.fadeOutTime;
        this.stayTime = title.stayTime;
        this.ticks = title.ticks;
    }

    public Title(String title, String subtitle, int fadeInTime, int stayTime, int fadeOutTime) {
        this.title = title;
        this.subtitle = subtitle;
        this.fadeInTime = fadeInTime;
        this.stayTime = stayTime;
        this.fadeOutTime = fadeOutTime;
    }

    private static void loadClasses() {
        if (packetTitle == null) {
            packetTitle = ReflectionUtils.getCraftClass("PacketPlayOutTitle");
            packetActions = ReflectionUtils.getCraftClass("PacketPlayOutTitle$EnumTitleAction");
            chatBaseComponent = ReflectionUtils.getCraftClass("IChatBaseComponent");
            nmsChatSerializer = ReflectionUtils.getCraftClass("IChatBaseComponent$ChatSerializer");
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setTitleColor(ChatColor color) {
        this.titleColor = color;
    }

    public void setSubtitleColor(ChatColor color) {
        this.subtitleColor = color;
    }

    public void setFadeInTime(int time) {
        this.fadeInTime = time;
    }

    public void setFadeOutTime(int time) {
        this.fadeOutTime = time;
    }

    public void setStayTime(int time) {
        this.stayTime = time;
    }

    public void setTimingsToTicks() {
        this.ticks = true;
    }

    public void setTimingsToSeconds() {
        this.ticks = false;
    }

    public void send(Player player) {
        if (packetTitle != null) {
            Title.resetTitle(player);
            try {
                Object handle = this.getHandle(player);
                Object connection = this.getField(handle.getClass(), "playerConnection").get(handle);
                ?[] actions = packetActions.getEnumConstants();
                Method sendPacket = this.getMethod(connection.getClass(), "sendPacket", new Class[0]);
                Object packet = packetTitle.getConstructor(packetActions, chatBaseComponent, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(actions[2], null, this.fadeInTime * (this.ticks ? 1 : 20), this.stayTime * (this.ticks ? 1 : 20), this.fadeOutTime * (this.ticks ? 1 : 20));
                if (this.fadeInTime != -1 && this.fadeOutTime != -1 && this.stayTime != -1) {
                    sendPacket.invoke(connection, packet);
                }
                Object serialized = this.getMethod(nmsChatSerializer, "a", String.class).invoke(null, "{text:\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)this.title) + "\",color:" + this.titleColor.name().toLowerCase() + "}");
                packet = packetTitle.getConstructor(packetActions, chatBaseComponent).newInstance(actions[0], serialized);
                sendPacket.invoke(connection, packet);
                if (this.subtitle != "") {
                    serialized = this.getMethod(nmsChatSerializer, "a", String.class).invoke(null, "{text:\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)this.subtitle) + "\",color:" + this.subtitleColor.name().toLowerCase() + "}");
                    packet = packetTitle.getConstructor(packetActions, chatBaseComponent).newInstance(actions[1], serialized);
                    sendPacket.invoke(connection, packet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void broadcast() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.send(p);
        }
    }

    public static void clearTitle(Player player) {
        try {
            Object handle = ReflectionUtils.getHandle((Entity)player);
            Object connection = ReflectionUtils.getField(handle.getClass(), "playerConnection").get(handle);
            ?[] actions = packetActions.getEnumConstants();
            Method sendPacket = ReflectionUtils.getMethod(connection.getClass(), "sendPacket");
            Object packet = packetTitle.getConstructor(packetActions, chatBaseComponent).newInstance(actions[3], null);
            sendPacket.invoke(connection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetTitle(Player player) {
        try {
            Object handle = ReflectionUtils.getHandle((Entity)player);
            Object connection = ReflectionUtils.getField(handle.getClass(), "playerConnection").get(handle);
            ?[] actions = packetActions.getEnumConstants();
            Method sendPacket = ReflectionUtils.getMethod(connection.getClass(), "sendPacket");
            Object packet = packetTitle.getConstructor(packetActions, chatBaseComponent).newInstance(actions[4], null);
            sendPacket.invoke(connection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Class<?> getPrimitiveType(Class<?> clazz) {
        return CORRESPONDING_TYPES.containsKey(clazz) ? CORRESPONDING_TYPES.get(clazz) : clazz;
    }

    private Class<?>[] toPrimitiveTypeArray(Class<?>[] classes) {
        int a = classes != null ? classes.length : 0;
        Class[] types = new Class[a];
        int i = 0;
        while (i < a) {
            types[i] = this.getPrimitiveType(classes[i]);
            ++i;
        }
        return types;
    }

    private static boolean equalsTypeArray(Class<?>[] a, Class<?>[] o) {
        if (a.length != o.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(o[i]) && !a[i].isAssignableFrom(o[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Object getHandle(Object obj) {
        try {
            return this.getMethod("getHandle", obj.getClass(), new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Method getMethod(String name, Class<?> clazz, Class<?> ... paramTypes) {
        Class<?>[] t = this.toPrimitiveTypeArray(paramTypes);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?>[] types = this.toPrimitiveTypeArray(m.getParameterTypes());
            if (m.getName().equals(name) && Title.equalsTypeArray(types, t)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private String getVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String version = String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + ".";
        return version;
    }

    private Class<?> getNMSClass(String className) {
        String fullName = "net.minecraft.server." + this.getVersion() + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazz;
    }

    private Field getField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name) && (args.length == 0 || this.ClassListEqual(args, m.getParameterTypes()))) {
                m.setAccessible(true);
                return m;
            }
            ++n2;
        }
        return null;
    }

    private boolean ClassListEqual(Class<?>[] l1, Class<?>[] l2) {
        boolean equal = true;
        if (l1.length != l2.length) {
            return false;
        }
        int i = 0;
        while (i < l1.length) {
            if (l1[i] != l2[i]) {
                equal = false;
                break;
            }
            ++i;
        }
        return equal;
    }
}

