/*
 * Decompiled with CFR 0.152.
 */
package net.minemora.LobbyAFK;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minemora.LobbyAFK.VaultManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LobbyAFK
extends JavaPlugin
implements Listener {
    FileConfiguration config = this.getConfig();
    String pluginMode;
    int timetosend;
    List<String> lobbies;
    List<String> afklobbies;
    boolean countdown;
    String cdmsg;
    String countcanceled;
    LobbyAFK plugin;
    Map<String, Long> lastactiontime = new HashMap<String, Long>();
    Set<String> countdownplayers = new HashSet<String>();
    int cdt;

    public void onEnable() {
        this.saveDefaultConfig();
        this.plugin = this;
        this.pluginMode = this.config.getString("plugin_mode").toLowerCase();
        this.timetosend = this.config.getInt("time_to_send");
        this.lobbies = this.config.getStringList("lobbies");
        this.afklobbies = this.config.getStringList("afk_lobbies");
        this.countdown = this.config.getBoolean("countdown");
        this.cdmsg = this.config.getString("countdown_message");
        this.countcanceled = this.config.getString("countdown_canceled_message");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        VaultManager.setup((Plugin)this);
        this.cdt = this.timetosend > 30 ? 30000 : (this.timetosend > 15 ? 15000 : (this.timetosend > 10 ? 10000 : (this.timetosend > 5 ? 5000 : 2000)));
        if (this.pluginMode.equals("lobby")) {
            new BukkitRunnable(){

                public void run() {
                    long currenttime = System.currentTimeMillis();
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (LobbyAFK.this.countdown) {
                            if (currenttime - LobbyAFK.this.lastactiontime.get(p.getName()) < (long)(LobbyAFK.this.timetosend * 1000 - LobbyAFK.this.cdt) || LobbyAFK.this.countdownplayers.contains(p.getName())) continue;
                            LobbyAFK.this.sendPlayer(p);
                            continue;
                        }
                        if (currenttime - LobbyAFK.this.lastactiontime.get(p.getName()) < (long)(LobbyAFK.this.timetosend * 1000)) continue;
                        LobbyAFK.this.sendPlayer(p);
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)this, 0L, 100L);
        }
        this.getLogger().info("Loaded fine! with plugin mode: " + this.pluginMode);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.updateCounter(e.getPlayer());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        this.updateCounter(e.getPlayer());
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent e) {
        this.updateCounter(e.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.lastactiontime.remove(e.getPlayer().getName());
        this.countdownplayers.remove(e.getPlayer().getName());
    }

    public void updateCounter(Player p) {
        if (this.pluginMode.equals("afk")) {
            this.sendPlayer(p);
            return;
        }
        if (this.pluginMode.equals("lobby")) {
            this.lastactiontime.put(p.getName(), System.currentTimeMillis());
        }
    }

    public void sendPlayer(final Player p) {
        if (this.pluginMode.equals("afk")) {
            String server = null;
            Random rand = new Random();
            server = this.lobbies.get(rand.nextInt(this.lobbies.size()));
            if (!this.lastactiontime.containsKey(p.getName())) {
                this.lastactiontime.put(p.getName(), 0L);
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF("Connect");
                out.writeUTF(server);
                p.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
                new BukkitRunnable(){

                    public void run() {
                        LobbyAFK.this.lastactiontime.remove(p.getName());
                    }
                }.runTaskLaterAsynchronously((Plugin)this, 60L);
            }
            return;
        }
        if (this.pluginMode.equals("lobby")) {
            if (VaultManager.hasPermission(p, "lobbyafk.bypass")) {
                return;
            }
            if (this.countdown) {
                this.countdownplayers.add(p.getName());
                new BukkitRunnable(){
                    int count;
                    {
                        this.count = LobbyAFK.this.cdt / 1000;
                    }

                    public void run() {
                        if (!LobbyAFK.this.lastactiontime.containsKey(p.getName())) {
                            this.cancel();
                            return;
                        }
                        long currenttime = System.currentTimeMillis();
                        if (currenttime - LobbyAFK.this.lastactiontime.get(p.getName()) >= (long)(LobbyAFK.this.timetosend * 1000 - LobbyAFK.this.cdt)) {
                            if (this.count == 0) {
                                String server = null;
                                Random rand = new Random();
                                server = LobbyAFK.this.afklobbies.get(rand.nextInt(LobbyAFK.this.afklobbies.size()));
                                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                                out.writeUTF("Connect");
                                out.writeUTF(server);
                                p.sendPluginMessage((Plugin)LobbyAFK.this.plugin, "BungeeCord", out.toByteArray());
                                this.cancel();
                                return;
                            }
                            if (this.count == 30) {
                                p.sendMessage(LobbyAFK.this.format(LobbyAFK.this.cdmsg.replaceAll("\\{second\\}", Integer.toString(this.count))));
                            }
                            if (this.count == 15) {
                                p.sendMessage(LobbyAFK.this.format(LobbyAFK.this.cdmsg.replaceAll("\\{second\\}", Integer.toString(this.count))));
                            }
                            if (this.count <= 10) {
                                p.sendMessage(LobbyAFK.this.format(LobbyAFK.this.cdmsg.replaceAll("\\{second\\}", Integer.toString(this.count))));
                            }
                            --this.count;
                        } else {
                            p.sendMessage(LobbyAFK.this.format(LobbyAFK.this.countcanceled));
                            LobbyAFK.this.countdownplayers.remove(p.getName());
                            this.cancel();
                        }
                    }
                }.runTaskTimerAsynchronously((Plugin)this, 0L, 20L);
            } else {
                String server = null;
                Random rand = new Random();
                server = this.afklobbies.get(rand.nextInt(this.afklobbies.size()));
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF("Connect");
                out.writeUTF(server);
                p.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
            }
        }
    }

    private String format(String m) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)m);
    }
}

