/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.players;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.ikevoodoo.smpcore.players.FakePlayer;
import me.ikevoodoo.smpcore.players.FakePlayerMessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

class FakeCommandSender
implements CommandSender {
    private final FakePlayer player;
    private final List<PermissionAttachment> attachments = new ArrayList<PermissionAttachment>();
    private final List<FakePlayerMessageHandler> messageHandlers = new ArrayList<FakePlayerMessageHandler>();
    private boolean isOp = false;

    public FakeCommandSender(FakePlayer player) {
        this.player = player;
    }

    public void addMessageHandler(FakePlayerMessageHandler handler) {
        this.messageHandlers.add(handler);
    }

    public void removeMessageHandler(FakePlayerMessageHandler handler) {
        this.messageHandlers.remove(handler);
    }

    public void sendMessage(String message) {
        for (FakePlayerMessageHandler handler : this.messageHandlers) {
            handler.onMessage(this.player, message);
        }
    }

    public void sendMessage(String ... messages) {
        for (FakePlayerMessageHandler handler : this.messageHandlers) {
            handler.onMessage(this.player, messages);
        }
    }

    public void sendMessage(UUID sender, String message) {
        for (FakePlayerMessageHandler handler : this.messageHandlers) {
            handler.onMessage(this.player, sender, message);
        }
    }

    public void sendMessage(UUID sender, String ... messages) {
        for (FakePlayerMessageHandler handler : this.messageHandlers) {
            handler.onMessage(this.player, sender, messages);
        }
    }

    public Server getServer() {
        return Bukkit.getServer();
    }

    public String getName() {
        return this.player.getName();
    }

    public CommandSender.Spigot spigot() {
        return null;
    }

    public boolean isPermissionSet(String name) {
        return false;
    }

    public boolean isPermissionSet(Permission perm) {
        return false;
    }

    public boolean hasPermission(String name) {
        for (PermissionAttachment attachment : this.attachments) {
            for (Map.Entry perm : attachment.getPermissions().entrySet()) {
                if (!((String)perm.getKey()).equals(name)) continue;
                return (Boolean)perm.getValue();
            }
        }
        return false;
    }

    public boolean hasPermission(Permission perm) {
        return this.hasPermission(perm.getName());
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        PermissionAttachment attachment = new PermissionAttachment(plugin, (Permissible)this);
        attachment.setPermission(name, value);
        this.attachments.add(attachment);
        return attachment;
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return null;
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return null;
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return null;
    }

    public void removeAttachment(PermissionAttachment attachment) {
        this.attachments.remove(attachment);
    }

    public void recalculatePermissions() {
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        HashSet<PermissionAttachmentInfo> permissions = new HashSet<PermissionAttachmentInfo>();
        for (PermissionAttachment attachment : this.attachments) {
            for (Map.Entry perm : attachment.getPermissions().entrySet()) {
                permissions.add(new PermissionAttachmentInfo((Permissible)this, (String)perm.getKey(), attachment, ((Boolean)perm.getValue()).booleanValue()));
            }
        }
        return permissions;
    }

    public boolean isOp() {
        return this.isOp;
    }

    public void setOp(boolean value) {
        this.isOp = value;
    }
}

