/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.particles;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.ikevoodoo.smpcore.math.helper.LineHelper;
import me.ikevoodoo.smpcore.particles.ParticleInfo;
import me.ikevoodoo.smpcore.particles.ParticleRendererBase;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PolygonParticleRenderer
implements ParticleRendererBase {
    private final List<ParticleInfo> particles = new ArrayList<ParticleInfo>();
    private boolean fill;
    private boolean edges;
    private double spacing = 2.0;

    public PolygonParticleRenderer fill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public PolygonParticleRenderer edges(boolean edges) {
        this.edges = edges;
        return this;
    }

    public PolygonParticleRenderer spacing(double spacing) {
        this.spacing = spacing;
        return this;
    }

    public PolygonParticleRenderer particle(ParticleInfo particle) {
        this.particles.add(particle);
        return this;
    }

    @Override
    public void render(World world) {
        if (this.fill) {
            return;
        }
        if (this.edges) {
            ParticleInfo prev = null;
            for (ParticleInfo particle : this.particles) {
                Consumer<Vector> consumer = particle.type() == Particle.REDSTONE ? pos -> world.spawnParticle(Particle.REDSTONE, pos.toLocation(world), particle.amount(), (Object)new Particle.DustOptions(particle.color(), particle.size())) : pos -> world.spawnParticle(particle.type(), pos.toLocation(world), particle.amount());
                if (prev != null) {
                    LineHelper.runOnLine(prev.location().toVector(), particle.location().toVector(), this.spacing, consumer);
                } else {
                    consumer.accept(particle.location().toVector());
                }
                prev = particle;
            }
            return;
        }
        for (ParticleInfo particle : this.particles) {
            if (particle == null) continue;
            for (ParticleInfo particleInfo : this.particles) {
                if (particleInfo == null || particleInfo.equals(particle)) continue;
                Consumer<Vector> consumer = particle.type() == Particle.REDSTONE ? pos -> world.spawnParticle(Particle.REDSTONE, pos.toLocation(world), particle.amount(), (Object)new Particle.DustOptions(particle.color(), particle.size())) : pos -> world.spawnParticle(particle.type(), pos.toLocation(world), particle.amount());
                LineHelper.runOnLine(particleInfo.location().toVector(), particle.location().toVector(), this.spacing, consumer);
            }
        }
    }

    @Override
    public void render(World world, Player player) {
        if (this.fill) {
            return;
        }
    }
}

