/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.listeners;

import me.ikevoodoo.smpcore.events.PlayerPreDeathEvent;
import me.ikevoodoo.smpcore.events.TotemCheckEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class PlayerDamageListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent event) {
        if (this.check(event.getEntity(), event.getFinalDamage(), this.getKiller(event.getDamager()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void on(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE || event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
            return;
        }
        if (this.check(event.getEntity(), event.getFinalDamage(), null)) {
            event.setCancelled(true);
        }
    }

    private boolean check(Entity killed, double finalDamage, Entity killer) {
        Entity entity = killed;
        if (!(entity instanceof Player)) {
            return false;
        }
        Player killedPlayer = (Player)entity;
        TotemCheckEvent totemCheckEvent = new TotemCheckEvent(killedPlayer);
        Bukkit.getPluginManager().callEvent((Event)totemCheckEvent);
        if (totemCheckEvent.hasTotem() || killedPlayer.getHealth() - finalDamage > 0.0) {
            return false;
        }
        PlayerPreDeathEvent playerPreDeathEvent = new PlayerPreDeathEvent(killedPlayer, killer);
        Bukkit.getPluginManager().callEvent((Event)playerPreDeathEvent);
        return playerPreDeathEvent.isCancelled();
    }

    private Entity getKiller(Entity entity) {
        Tameable tameable;
        AnimalTamer owner;
        EnderCrystal crystal;
        Entity cause;
        Entity entity2;
        Entity tntPrimed;
        Projectile arrow;
        Entity entity3 = entity;
        if (entity3 instanceof Projectile && (entity3 = (arrow = (Projectile)entity3).getShooter()) instanceof Entity) {
            Entity e = entity3;
            return this.getKiller(e);
        }
        Entity e = entity;
        if (e instanceof TNTPrimed) {
            TNTPrimed primed = (TNTPrimed)e;
            while ((entity3 = primed.getSource()) instanceof TNTPrimed) {
                tntPrimed = (TNTPrimed)entity3;
                primed = tntPrimed;
            }
            return this.getKiller(primed.getSource());
        }
        tntPrimed = entity;
        if (tntPrimed instanceof EnderCrystal && (entity2 = (cause = (crystal = (EnderCrystal)tntPrimed).getLastDamageCause())) instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent event = (EntityDamageByEntityEvent)entity2;
            return this.getKiller(event.getDamager());
        }
        cause = entity;
        if (cause instanceof Tameable && (entity2 = (owner = (tameable = (Tameable)cause).getOwner())) instanceof Entity) {
            Entity e2 = entity2;
            return this.getKiller(e2);
        }
        return entity;
    }
}

