/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.listeners;

import java.util.HashMap;
import java.util.Map;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.callbacks.Callback;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class CallbackListener<T extends Callback>
implements Listener {
    private final SMPPlugin plugin;
    private final HashMap<NamespacedKey, T> callbacks = new HashMap();

    CallbackListener(SMPPlugin plugin) {
        this.plugin = plugin;
    }

    protected T getCallback(String key) {
        return (T)((Callback)this.callbacks.get(new NamespacedKey((Plugin)this.plugin, key)));
    }

    protected HashMap<NamespacedKey, T> getCallbacks() {
        return this.callbacks;
    }

    protected T getCallback(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (Map.Entry<NamespacedKey, T> entry : this.callbacks.entrySet()) {
            if (!container.has(entry.getKey(), PersistentDataType.INTEGER)) continue;
            return (T)((Callback)entry.getValue());
        }
        return null;
    }

    public void addListener(String key, T callback) {
        this.addListener(new NamespacedKey((Plugin)this.plugin, key), callback);
    }

    public void addListener(NamespacedKey key, T callback) {
        this.callbacks.put(key, callback);
    }

    public void removeListener(String key) {
        this.removeListener(new NamespacedKey((Plugin)this.plugin, key));
    }

    public void removeListener(NamespacedKey key) {
        this.callbacks.remove(key);
    }
}

