/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.handlers.chat;

import java.util.HashMap;
import java.util.UUID;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.callbacks.chat.ChatTransactionListener;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ChatInputHandler
extends PluginProvider {
    private final HashMap<UUID, ChatTransactionListener> listeners = new HashMap();

    public ChatInputHandler(SMPPlugin plugin) {
        super(plugin);
    }

    public void onChatInput(Player player, ChatTransactionListener listener, String ... messages) {
        for (String message : messages) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
        this.listeners.put(player.getUniqueId(), listener);
    }

    public void onChatInput(Player player, ChatTransactionListener listener, boolean cancellable, String ... messages) {
        if (cancellable) {
            this.onCancellableInput(player, listener, "\u00a7cType \"\u00a7ccancel\u00a7c\" to cancel.", "\u00a7aSuccessfully cancelled", messages);
        } else {
            this.onChatInput(player, listener, messages);
        }
    }

    public void onCancellableInput(Player player, ChatTransactionListener listener, String cancelMessage, String cancelledMessage, String ... messages) {
        for (String message : messages) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)cancelMessage));
        this.listeners.put(player.getUniqueId(), s -> {
            if (s.equalsIgnoreCase("cancel")) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)cancelledMessage));
                listener.onComplete(false);
                return true;
            }
            return listener.onChat(s);
        });
    }

    public boolean hasListener(UUID id) {
        return this.listeners.containsKey(id);
    }

    public boolean hasListener(Player player) {
        return this.hasListener(player.getUniqueId());
    }

    public void removeListener(UUID id) {
        this.listeners.remove(id);
    }

    public void removeListener(Player player) {
        this.removeListener(player.getUniqueId());
    }

    public void runListener(UUID id, String message) {
        if (this.listeners.containsKey(id) && Boolean.TRUE.equals(this.listeners.get(id).onChat(message))) {
            this.listeners.remove(id).onComplete(true);
        }
    }

    public void runListener(Player player, String message) {
        this.runListener(player.getUniqueId(), message);
    }
}

