/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.config;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.config.annotations.BooleanDefault;
import me.ikevoodoo.smpcore.config.annotations.Config;
import me.ikevoodoo.smpcore.config.annotations.ConfigType;
import me.ikevoodoo.smpcore.config.annotations.DoubleDefault;
import me.ikevoodoo.smpcore.config.annotations.IntDefault;
import me.ikevoodoo.smpcore.config.annotations.LongDefault;
import me.ikevoodoo.smpcore.config.annotations.StringDefault;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigData {
    private final String name;
    private final File file;
    private final String type;
    private final HashMap<String, Object> defaults;
    private final Class<?> clazz;
    private FileConfiguration config;

    public ConfigData(SMPPlugin plugin, String name, String type, Class<?> clazz) {
        this.name = name;
        this.defaults = new HashMap();
        if (type.isBlank() && !name.contains(".")) {
            type = "yml";
        }
        this.file = new File(plugin.getDataFolder(), (String)(name.endsWith("." + type) ? name : name + "." + type));
        this.type = type;
        this.clazz = clazz;
        try {
            this.setDefaults(clazz);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (!this.file.exists()) {
            if (!this.file.getParentFile().mkdirs()) {
                plugin.getLogger().warning("Unable to create file parent folder: " + this.file.getParentFile().getAbsolutePath());
            }
            try {
                if (!this.file.createNewFile()) {
                    plugin.getLogger().warning("Unable to create file: " + this.file.getAbsolutePath());
                }
                this.loadConfig();
                this.set(clazz, null, (ConfigurationSection)this.config);
                this.save();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.reload();
    }

    public String getName() {
        return this.name;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public <T> T get(String path, Class<T> type) {
        return type.cast(this.config.get(path, this.defaults.get(path)));
    }

    public Object getDefault(String path) {
        return this.defaults.get(path);
    }

    public void reload() {
        this.loadConfig();
        this.load(this.clazz, (ConfigurationSection)this.config);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        switch (this.type) {
            case "yml": 
            case "yaml": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown config type: " + this.type);
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void setDefaults(Class<?> clazz) throws IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            this.setFieldDefault(field.getName(), field);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
            this.setNestedDefaults((Class<?>)annotatedElement, clazz.getSimpleName().toLowerCase(Locale.ROOT));
        }
    }

    private void setNestedDefaults(Class<?> clazz, String path) throws IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            this.setFieldDefault(path + "." + field.getName(), field);
        }
    }

    private void set(Class<?> clazz, Object o, ConfigurationSection section) {
        for (Field field : clazz.getFields()) {
            try {
                List list;
                if (field.getType().isAnnotationPresent(Config.class)) {
                    this.set(field.getType(), o, section.createSection(field.getName()));
                    continue;
                }
                Object value = field.get(o);
                if (value == null) continue;
                if (List.class.isAssignableFrom(field.getType()) && !(list = (List)value).isEmpty()) {
                    Class<?> listType = list.get(0).getClass();
                    if (!listType.isAnnotationPresent(ConfigType.class)) {
                        section.set(field.getName(), (Object)list);
                        continue;
                    }
                    String elementName = listType.getSimpleName().toLowerCase(Locale.ROOT);
                    ConfigurationSection elementSection = section.createSection(field.getName());
                    elementSection.set("doNotTouch", (Object)listType.getName());
                    for (int i = 0; i < list.size(); ++i) {
                        ConfigurationSection sec = elementSection.createSection(elementName + "_" + i);
                        Object element = list.get(i);
                        for (Field f : listType.getDeclaredFields()) {
                            boolean accessible = f.canAccess(element);
                            f.setAccessible(true);
                            sec.set(f.getName(), f.get(element));
                            f.setAccessible(accessible);
                        }
                    }
                    continue;
                }
                if (field.isEnumConstant()) {
                    section.set(field.getName(), (Object)value.toString());
                    continue;
                }
                section.set(field.getName(), value);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
            this.set((Class<?>)annotatedElement, o, section.createSection(((Class)annotatedElement).getSimpleName().toLowerCase(Locale.ROOT)));
        }
    }

    private void load(Class<?> clazz, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        block2: for (Field field : clazz.getFields()) {
            try {
                if (field.getType().isAnnotationPresent(Config.class)) {
                    this.load(field.getType(), section.getConfigurationSection(field.getName()));
                    continue;
                }
                if (section.isConfigurationSection(field.getName())) {
                    ConfigurationSection listSection;
                    if (!List.class.isAssignableFrom(field.getType()) || (listSection = section.getConfigurationSection(field.getName())) == null) continue;
                    ?[] storedType = listSection.getString("doNotTouch");
                    ClassLoader loader = this.getClass().getClassLoader();
                    Class<?> elementType = loader.loadClass((String)storedType);
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (String key : listSection.getKeys(false)) {
                        Object element;
                        ConfigurationSection sec = listSection.getConfigurationSection(key);
                        if (sec == null || (element = this.get(elementType)) == null) continue;
                        for (Field f : elementType.getDeclaredFields()) {
                            boolean accessible = f.canAccess(element);
                            f.setAccessible(true);
                            f.set(element, sec.get(f.getName()));
                            f.setAccessible(accessible);
                        }
                        list.add(element);
                    }
                    field.set(null, list);
                    continue;
                }
                Object val = section.get(field.getName(), this.defaults.get(field.getName()));
                if (val == null) continue;
                if (field.getType().isEnum()) {
                    for (Object o : field.getType().getEnumConstants()) {
                        if (!o.toString().equals(val.toString())) continue;
                        field.set(null, o);
                        continue block2;
                    }
                    continue;
                }
                Object object = val;
                if (object instanceof String) {
                    String str = (String)object;
                    field.set(null, ChatColor.translateAlternateColorCodes((char)'&', (String)str));
                    continue;
                }
                field.set(null, val);
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                // empty catch block
            }
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
            this.load((Class<?>)annotatedElement, section.getConfigurationSection(((Class)annotatedElement).getSimpleName().toLowerCase(Locale.ROOT)));
        }
    }

    private Object get(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void setFieldDefault(String path, Field field) throws IllegalAccessException {
        this.checkType(path, field, DoubleDefault.class, Double.TYPE, Double.class);
        this.checkType(path, field, IntDefault.class, Integer.TYPE, Integer.class);
        this.checkType(path, field, StringDefault.class, String.class);
        this.checkType(path, field, BooleanDefault.class, Boolean.TYPE, Boolean.class);
        this.checkType(path, field, LongDefault.class, Long.TYPE, Long.class);
    }

    private void checkType(String path, Field field, Class<? extends Annotation> annotation, Class<?> ... types) throws IllegalAccessException {
        if (field.isAnnotationPresent(annotation)) {
            if (Arrays.stream(types).noneMatch(field.getType()::isAssignableFrom)) {
                throw new IllegalArgumentException("Field " + path + " is not a " + types[0].getSimpleName());
            }
            try {
                Field value = annotation.getDeclaredField("value");
                if (value.getType() == types[0]) {
                    this.defaults.put(path, value.get(null));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                this.defaults.put(path, field.get(null));
            }
        }
    }
}

