/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.commands.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.commands.CommandUsable;
import me.ikevoodoo.smpcore.commands.Context;
import me.ikevoodoo.smpcore.commands.SMPCommand;
import me.ikevoodoo.smpcore.commands.arguments.Argument;
import me.ikevoodoo.smpcore.commands.functional.CommandReturn;
import me.ikevoodoo.smpcore.functional.loop.FunctionalLoopBase;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import me.ikevoodoo.smpcore.utils.Pair;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class FunctionalCommand
extends PluginProvider
implements FunctionalLoopBase {
    private String name;
    private String perm;
    private CommandUsable usable;
    private final List<Runnable> bound = new ArrayList<Runnable>();
    private final List<Consumer<Context<?>>> consumers = new ArrayList();
    private final List<Supplier<Pair<CommandReturn, Object>>> then = new ArrayList<Supplier<Pair<CommandReturn, Object>>>();
    private final List<Function<Context<?>, Pair<CommandReturn, Object>>> consumerThen = new ArrayList();
    private final List<Argument> arguments = new ArrayList<Argument>();
    private final List<FunctionalCommand> subFunctional = new ArrayList<FunctionalCommand>();
    private final List<SMPCommand> subCommands = new ArrayList<SMPCommand>();

    protected FunctionalCommand(SMPPlugin plugin) {
        super(plugin);
    }

    public FunctionalCommand name(String name) {
        this.name = name;
        return this;
    }

    public FunctionalCommand perm(String perm) {
        this.perm = perm;
        return this;
    }

    public FunctionalCommand usable(CommandUsable usable) {
        this.usable = usable;
        return this;
    }

    public FunctionalCommand bind(Runnable bound) {
        if (bound != null) {
            this.bound.add(bound);
        }
        return this;
    }

    public FunctionalCommand bind(Consumer<Context<?>> bound) {
        if (bound != null) {
            this.consumers.add(bound);
        }
        return this;
    }

    public FunctionalCommand then(Supplier<Pair<CommandReturn, Object>> then) {
        if (then != null) {
            this.then.add(then);
        }
        return this;
    }

    public FunctionalCommand then(Function<Context<?>, Pair<CommandReturn, Object>> then) {
        if (then != null) {
            this.consumerThen.add(then);
        }
        return this;
    }

    public FunctionalCommand arg(Argument argument) {
        if (argument != null) {
            this.arguments.add(argument);
        }
        return this;
    }

    public FunctionalCommand arg(Argument argument, Argument ... arguments) {
        this.arg(argument);
        for (Argument arg : arguments) {
            this.arg(arg);
        }
        return this;
    }

    public FunctionalCommand sub(SMPCommand command) {
        this.subCommands.add(command);
        return this;
    }

    public FunctionalCommand sub(FunctionalCommand command) {
        this.subFunctional.add(command);
        return this;
    }

    public void register() {
        this.getPlugin().addCommand(this.getCommand());
    }

    private SMPCommand getCommand() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot register a command without a name! Plugin: " + this.getPlugin().getName());
        }
        SMPCommand command = new SMPCommand(this.getPlugin(), this.name, null){

            @Override
            public boolean execute(Context<?> context) {
                Pair functionReturn;
                for (Runnable runnable : FunctionalCommand.this.bound) {
                    runnable.run();
                }
                for (Consumer consumer : FunctionalCommand.this.consumers) {
                    consumer.accept(context);
                }
                for (Supplier supplier : FunctionalCommand.this.then) {
                    functionReturn = (Pair)supplier.get();
                    switch ((CommandReturn)((Object)functionReturn.getFirst())) {
                        case SEND_MESSAGE: {
                            context.source().sendMessage(String.valueOf(functionReturn.getSecond()));
                            break;
                        }
                        case EXECUTE_AS_SENDER: {
                            Bukkit.dispatchCommand(context.source(), (String)String.valueOf(functionReturn.getSecond()));
                            break;
                        }
                        case EXECUTE: {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)String.valueOf(functionReturn.getSecond()));
                        }
                    }
                }
                for (Function function : FunctionalCommand.this.consumerThen) {
                    functionReturn = (Pair)function.apply(context);
                    switch ((CommandReturn)((Object)functionReturn.getFirst())) {
                        case SEND_MESSAGE: {
                            context.source().sendMessage(String.valueOf(functionReturn.getSecond()));
                            break;
                        }
                        case EXECUTE_AS_SENDER: {
                            Bukkit.dispatchCommand(context.source(), (String)String.valueOf(functionReturn.getSecond()));
                            break;
                        }
                        case EXECUTE: {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)String.valueOf(functionReturn.getSecond()));
                        }
                    }
                }
                return true;
            }
        };
        command.setUsable(this.usable);
        command.setArgs(this.arguments.toArray(new Argument[0]));
        command.setPermission(this.perm);
        ArrayList<SMPCommand> sub = new ArrayList<SMPCommand>(this.subCommands);
        for (FunctionalCommand cmd : this.subFunctional) {
            sub.add(cmd.getCommand());
        }
        command.registerSubCommands(sub.toArray(new SMPCommand[0]));
        return command;
    }
}

