/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.commands.arguments.parsers;

import java.util.HashMap;
import java.util.UUID;
import me.ikevoodoo.smpcore.commands.arguments.parsers.BaseParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.BooleanParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.DoubleParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.FloatParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.IntParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.LongParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.OfflinePlayerParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.PlayerParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.StringParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.UUIDParser;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ParserRegistry {
    private static final HashMap<Class<?>, BaseParser<?>> parsers = new HashMap();

    private ParserRegistry() {
    }

    public static void register(BaseParser<?> parser, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            parsers.put(clazz, parser);
        }
    }

    public static <T> BaseParser<T> get(Class<T> clazz) {
        return parsers.get(clazz);
    }

    public static boolean has(Class<?> clazz) {
        return parsers.containsKey(clazz);
    }

    static {
        ParserRegistry.register(new UUIDParser(), UUID.class);
        ParserRegistry.register(new PlayerParser(), Player.class);
        ParserRegistry.register(new OfflinePlayerParser(), OfflinePlayer.class);
        ParserRegistry.register(new IntParser(), Integer.TYPE, Integer.class);
        ParserRegistry.register(new DoubleParser(), Double.TYPE, Double.class);
        ParserRegistry.register(new FloatParser(), Float.TYPE, Float.class);
        ParserRegistry.register(new LongParser(), Long.TYPE, Long.class);
        ParserRegistry.register(new BooleanParser(), Boolean.TYPE, Boolean.class);
        ParserRegistry.register(new StringParser(), String.class);
    }
}

