/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.commands.arguments;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import me.ikevoodoo.smpcore.commands.arguments.Argument;
import me.ikevoodoo.smpcore.commands.arguments.ArgumentWrapper;
import me.ikevoodoo.smpcore.commands.arguments.parsers.BaseParser;
import me.ikevoodoo.smpcore.commands.arguments.parsers.ParserRegistry;
import org.bukkit.command.CommandSender;

public class Arguments
implements Iterable<Integer> {
    private static final int READING_STRING = 0;
    private static final int READING_TOKEN = 1;
    private static final int SEARCHING_TOKEN = 2;
    private final List<String> args;
    private List<ArgumentWrapper> types;
    private final CommandSender sender;

    public Arguments(CommandSender sender, String[] args) {
        this.args = this.getArguments(String.join((CharSequence)" ", args));
        this.sender = sender;
    }

    public boolean match(List<ArgumentWrapper> args) {
        this.types = args;
        int currIndex = 0;
        for (ArgumentWrapper wrapper : args) {
            Argument arg = wrapper.getArgument();
            if (!this.has(arg.type())) {
                return false;
            }
            if (currIndex >= this.args.size()) {
                return !arg.required();
            }
            if (!this.is(currIndex, arg.type())) {
                if (!arg.required()) continue;
                return false;
            }
            ++currIndex;
        }
        return true;
    }

    private int find(String name) {
        int currIndex = 0;
        for (ArgumentWrapper wrapper : this.types) {
            Argument arg = wrapper.getArgument();
            if (arg.name().equalsIgnoreCase(name)) {
                return currIndex;
            }
            if (!this.has(arg.type())) {
                return -1;
            }
            if (!this.is(currIndex, arg.type())) {
                if (!arg.required()) continue;
                return -1;
            }
            ++currIndex;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.args.isEmpty();
    }

    public boolean has(Class<?> type) {
        return ParserRegistry.get(type) != null;
    }

    public boolean is(int index, Class<?> type) {
        if (index >= this.args.size()) {
            return false;
        }
        return ParserRegistry.get(type) != null && ParserRegistry.get(type).canParse(this.args.get(index));
    }

    public <T> T get(int index, Class<T> type) {
        if (index >= this.args.size()) {
            return null;
        }
        String data = this.args.get(index);
        if (type == String.class) {
            return type.cast(data);
        }
        BaseParser<T> parser = ParserRegistry.get(type);
        if (parser == null || !parser.canParse(data)) {
            return null;
        }
        return parser.parse(this.sender, data);
    }

    public <T> T get(String name, Class<T> type) {
        return this.get(this.find(name), type);
    }

    public <T> T get(int index, Class<T> type, T def) {
        T v = this.get(index, type);
        if (v == null) {
            return def;
        }
        return v;
    }

    public <T> T get(String name, Class<T> type, T def) {
        return this.get(this.find(name), type, def);
    }

    public <T> List<T> getAll(Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.args.size(); ++i) {
            if (!this.is(i, type)) continue;
            list.add(this.get(i, type));
        }
        return list;
    }

    public boolean has(String name) {
        int found = this.find(name);
        return found > 0 && found < this.args.size();
    }

    public String get(int index) {
        return index > this.args.size() ? null : this.args.get(index);
    }

    public String get(int index, String def) {
        return index >= this.args.size() || index < 0 ? def : this.args.get(index);
    }

    private List<String> getArguments(String input) {
        int state = 2;
        StringBuilder currentToken = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        block5: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (state) {
                case 2: {
                    if (c == '\"') {
                        state = 0;
                        continue block5;
                    }
                    if (c == ' ') continue block5;
                    state = 1;
                    currentToken.append(c);
                    continue block5;
                }
                case 0: {
                    if (c == '\"' && input.charAt(i - 1) != '\\') {
                        state = 2;
                        tokens.add(currentToken.toString());
                        currentToken.setLength(0);
                        continue block5;
                    }
                    if (input.charAt(i - 1) == '\\' && c == '\"') {
                        currentToken.setCharAt(currentToken.length() - 1, '\"');
                        continue block5;
                    }
                    currentToken.append(c);
                    continue block5;
                }
                case 1: {
                    if (c == ' ') {
                        state = 2;
                        tokens.add(currentToken.toString());
                        currentToken.setLength(0);
                        continue block5;
                    }
                    currentToken.append(c);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Achievement get: How did you get here?");
                }
            }
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int pos;

            @Override
            public boolean hasNext() {
                return this.pos < Arguments.this.args.size();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.pos++;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        Iterable.super.forEach(action);
    }

    @Override
    public Spliterator<Integer> spliterator() {
        return Iterable.super.spliterator();
    }
}

