/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import me.ikevoodoo.smpcore.annotations.NoInject;
import me.ikevoodoo.smpcore.annotations.Property;
import me.ikevoodoo.smpcore.callbacks.blocks.PlayerPlaceBlockCallback;
import me.ikevoodoo.smpcore.callbacks.items.PlayerUseItemCallback;
import me.ikevoodoo.smpcore.commands.SMPCommand;
import me.ikevoodoo.smpcore.commands.functional.CommandCreator;
import me.ikevoodoo.smpcore.commands.functional.FunctionalCommand;
import me.ikevoodoo.smpcore.config.ConfigData;
import me.ikevoodoo.smpcore.config.ConfigHandler;
import me.ikevoodoo.smpcore.config.ConfigHelper;
import me.ikevoodoo.smpcore.config.annotations.Config;
import me.ikevoodoo.smpcore.handlers.EliminationHandler;
import me.ikevoodoo.smpcore.handlers.InventoryActionHandler;
import me.ikevoodoo.smpcore.handlers.JoinActionHandler;
import me.ikevoodoo.smpcore.handlers.MenuHandler;
import me.ikevoodoo.smpcore.handlers.ResourcePackHandler;
import me.ikevoodoo.smpcore.handlers.chat.ChatInputHandler;
import me.ikevoodoo.smpcore.items.CustomItem;
import me.ikevoodoo.smpcore.items.functional.FunctionalItem;
import me.ikevoodoo.smpcore.items.functional.ItemCreator;
import me.ikevoodoo.smpcore.listeners.ChatMessageListener;
import me.ikevoodoo.smpcore.listeners.InventoryEditListener;
import me.ikevoodoo.smpcore.listeners.ItemDamageListener;
import me.ikevoodoo.smpcore.listeners.MenuUpdateListener;
import me.ikevoodoo.smpcore.listeners.PlayerConnectListener;
import me.ikevoodoo.smpcore.listeners.PlayerDamageListener;
import me.ikevoodoo.smpcore.listeners.PlayerPlaceListener;
import me.ikevoodoo.smpcore.listeners.PlayerSleepListener;
import me.ikevoodoo.smpcore.listeners.PlayerUseListener;
import me.ikevoodoo.smpcore.menus.Menu;
import me.ikevoodoo.smpcore.menus.functional.FunctionalMenu;
import me.ikevoodoo.smpcore.menus.functional.MenuCreator;
import me.ikevoodoo.smpcore.recipes.RecipeLoader;
import me.ikevoodoo.smpcore.senders.CustomSender;
import me.ikevoodoo.smpcore.senders.SenderBuilder;
import me.ikevoodoo.smpcore.utils.CommandUtils;
import me.ikevoodoo.smpcore.utils.FileUtils;
import me.ikevoodoo.smpcore.utils.NetworkUtils;
import me.ikevoodoo.smpcore.utils.PDCUtils;
import me.ikevoodoo.smpcore.utils.Pair;
import me.ikevoodoo.smpcore.utils.health.HealthHelper;
import me.ikevoodoo.smpcore.utils.random.MaterialUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SMPPlugin
extends JavaPlugin
implements CommandCreator,
MenuCreator,
ItemCreator {
    private EliminationHandler eliminationHandler;
    private JoinActionHandler joinActionHandler;
    private InventoryActionHandler inventoryActionHandler;
    private ResourcePackHandler resourcePackHandler;
    private ChatInputHandler chatInputHandler;
    private MenuHandler menuHandler;
    private RecipeLoader recipeLoader;
    private PlayerUseListener playerUseListener;
    private PlayerPlaceListener playerPlaceListener;
    private ConfigHelper configHelper;
    private ConfigHandler configHandler;
    private HealthHelper healthHelper;
    private MaterialUtils materialUtils;
    private File cacheFolder;
    private String serverIp;
    private final CommandSender noLogConsole = SenderBuilder.createNewSender(CustomSender.as().noLog().console());
    private final Random random = new Random();
    private final HashMap<String, CustomItem> customItems = new HashMap();

    public final void onLoad() {
        this.onPreload();
    }

    public final void onEnable() {
        this.eliminationHandler = new EliminationHandler(this);
        try {
            this.eliminationHandler.load(FileUtils.getOrCreate(this.getDataFolder(), "data", "cache.bin"));
        }
        catch (IOException e) {
            this.getLogger().severe("Could not load cache data!");
        }
        this.joinActionHandler = new JoinActionHandler(this);
        this.inventoryActionHandler = new InventoryActionHandler(this);
        this.resourcePackHandler = new ResourcePackHandler(this);
        this.chatInputHandler = new ChatInputHandler(this);
        this.menuHandler = new MenuHandler(this);
        this.recipeLoader = new RecipeLoader(this);
        this.playerUseListener = new PlayerUseListener(this);
        this.playerPlaceListener = new PlayerPlaceListener(this);
        this.registerListeners(new PlayerConnectListener(this), this.playerUseListener, this.playerPlaceListener, new PlayerDamageListener(), new PlayerSleepListener(), new InventoryEditListener(this), new ChatMessageListener(this), new MenuUpdateListener(this), new ItemDamageListener(this));
        this.configHandler = new ConfigHandler(this);
        try {
            this.registerDynamically();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        this.configHelper = new ConfigHelper(this);
        this.healthHelper = new HealthHelper(this);
        this.materialUtils = new MaterialUtils();
        try {
            this.cacheFolder = FileUtils.getOrCreate(this.getDataFolder(), "data", "cache");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String ip = Bukkit.getIp();
        this.serverIp = ip.isBlank() ? NetworkUtils.getServerIp() : ip;
        this.whenEnabled();
    }

    public final void onDisable() {
        try {
            this.eliminationHandler.save(FileUtils.getOrCreate(this.getDataFolder(), "data", "cache.bin"));
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save cache data!");
        }
        this.whenDisabled();
    }

    public void onPreload() {
    }

    public void whenEnabled() {
    }

    public void whenDisabled() {
    }

    public void onReload() {
    }

    public final void reload() {
        this.reload(false);
    }

    public final void reload(boolean skipEvent) {
        this.reloadConfig();
        this.configHandler.reload();
        for (CustomItem customItem : this.customItems.values()) {
            customItem.reload();
        }
        if (!skipEvent) {
            this.onReload();
        }
    }

    public final EliminationHandler getEliminationHandler() {
        return this.eliminationHandler;
    }

    public final JoinActionHandler getJoinActionHandler() {
        return this.joinActionHandler;
    }

    public final InventoryActionHandler getInventoryActionHandler() {
        return this.inventoryActionHandler;
    }

    public final ResourcePackHandler getResourcePackHandler() {
        return this.resourcePackHandler;
    }

    public final ChatInputHandler getChatInputHandler() {
        return this.chatInputHandler;
    }

    public final MenuHandler getMenuHandler() {
        return this.menuHandler;
    }

    public final RecipeLoader getRecipeLoader() {
        return this.recipeLoader;
    }

    public final ConfigHelper getConfigHelper() {
        return this.configHelper;
    }

    public final HealthHelper getHealthHelper() {
        return this.healthHelper;
    }

    public final ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public final MaterialUtils getMaterialUtils() {
        return this.materialUtils;
    }

    public final File getCacheFolder() {
        return this.cacheFolder;
    }

    public final String getServerIp() {
        return this.serverIp;
    }

    public final Random getRandom() {
        return this.random;
    }

    public final CommandSender getNoLogConsole() {
        return this.noLogConsole;
    }

    public final CommandSender getConsole() {
        return Bukkit.getConsoleSender();
    }

    public final void onUse(String key, PlayerUseItemCallback callback) {
        this.playerUseListener.addListener(key, callback);
    }

    public final void onUse(NamespacedKey key, PlayerUseItemCallback callback) {
        this.playerUseListener.addListener(key, callback);
    }

    public final void onPlace(String key, PlayerPlaceBlockCallback callback) {
        this.playerPlaceListener.addListener(key, callback);
    }

    public final void addCommand(String name, SMPCommand executor) {
        PluginCommand command = this.getCommand(name);
        assert (command != null);
        command.setExecutor((CommandExecutor)executor);
        command.setTabCompleter((TabCompleter)executor);
    }

    public final void addCommand(SMPCommand command) {
        PluginCommand cmd = this.getCommand(command.getName());
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)command);
            cmd.setTabCompleter((TabCompleter)command);
            return;
        }
        CommandUtils.register(command);
    }

    public final void addCommands(List<SMPCommand> commands) {
        commands.forEach(this::addCommand);
    }

    public final void addCommand(String name, SMPCommand executor, TabCompleter completer) {
        PluginCommand command = this.getCommand(name);
        assert (command != null);
        command.setExecutor((CommandExecutor)executor);
        command.setTabCompleter(completer);
    }

    public final void registerListeners(Listener ... listeners) {
        for (Listener listener : listeners) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    public final void registerListeners(List<Listener> listeners) {
        listeners.forEach(listener -> this.getServer().getPluginManager().registerEvents(listener, (Plugin)this));
    }

    public final String getString(String path) {
        return this.getConfig().getString(path);
    }

    public final int getInt(String path) {
        return this.getConfig().getInt(path);
    }

    public final boolean getBoolean(String path) {
        return this.getConfig().getBoolean(path);
    }

    public final double getDouble(String path) {
        return this.getConfig().getDouble(path);
    }

    public final long getLong(String path) {
        return this.getConfig().getLong(path);
    }

    public final ConfigurationSection getSection(String path) {
        return this.getConfig().getConfigurationSection(path);
    }

    public final void set(String path, Object value) {
        this.getConfig().set(path, value);
    }

    public final Optional<CustomItem> getItem(String id) {
        CustomItem item = this.customItems.get(id);
        if (item == null) {
            return Optional.empty();
        }
        return Optional.of(item);
    }

    public final Optional<CustomItem> getItem(ItemStack stack) {
        if (stack == null) {
            return Optional.empty();
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return Optional.empty();
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Optional data = PDCUtils.get(container, PersistentDataType.BYTE);
        if (data.isEmpty()) {
            return Optional.empty();
        }
        return this.getItem(data.get().getFirst());
    }

    public final void registerItem(CustomItem item) {
        if (item == null) {
            throw new IllegalStateException("Item must not be null!");
        }
        this.customItems.put(item.getId(), item);
    }

    public final List<CustomItem> getItems() {
        return new ArrayList<CustomItem>(this.customItems.values());
    }

    public final NamespacedKey makeKey(String id) {
        return new NamespacedKey((Plugin)this, id);
    }

    public final FunctionalCommand createCommand() {
        return this.createCommand(this);
    }

    public final FunctionalMenu createMenu() {
        return this.createMenu(this);
    }

    public final FunctionalItem createItem() {
        return this.createItem(this);
    }

    public final void destroyMenu(String id) {
        this.menuHandler.remove(this.makeKey(id));
    }

    public final void destroyMenu(NamespacedKey key) {
        this.menuHandler.remove(key);
    }

    public final void destroyMenu(Menu menu) {
        this.menuHandler.remove(menu.id());
        this.playerUseListener.removeListener(menu.id());
    }

    public final void destroyItem(String id) {
        this.customItems.remove(id);
    }

    public final void destroyItem(NamespacedKey key) {
        this.destroyItem(key.getKey());
    }

    public final void destroyItem(CustomItem item) {
        this.destroyItem(item.getId());
    }

    public final boolean isInstalled(String id) {
        return Bukkit.getPluginManager().getPlugin(id) != null;
    }

    public static SMPPlugin getById(String id) {
        SMPPlugin smpPlugin;
        Plugin plugin = Bukkit.getPluginManager().getPlugin(id);
        return plugin instanceof SMPPlugin ? (smpPlugin = (SMPPlugin)plugin) : null;
    }

    private void registerDynamically() throws IOException, URISyntaxException {
        List<Class<?>> classes = this.getAllClasses(this.getClass().getPackage().getName());
        this.findConfigClasses(classes).forEach(clazz -> {
            Config config = clazz.getAnnotation(Config.class);
            ConfigData data = new ConfigData(this, config.value(), config.type(), (Class<?>)clazz);
            this.getConfigHandler().registerConfig(data);
        });
        Pair<List<Listener>, List<SMPCommand>> toRegister = this.checkPackageForClasses(classes, Listener.class, SMPCommand.class);
        this.registerListeners(toRegister.getFirst());
        this.addCommands(toRegister.getSecond());
        this.findItemClasses(classes).forEach(clazz -> {
            CustomItem item = this.getClassInstance(clazz.asSubclass(CustomItem.class));
            assert (item != null);
            this.registerItem(item);
        });
    }

    private <A, B> Pair<List<A>, List<B>> checkPackageForClasses(List<Class<?>> classes, Class<A> toFindA, Class<B> toFindB) {
        if (classes == null) {
            return new Pair<List<A>, List<B>>(new ArrayList(), new ArrayList());
        }
        ArrayList<A> foundClassesA = new ArrayList<A>();
        ArrayList<A> foundClassesB = new ArrayList<A>();
        for (Class<?> clazz : classes) {
            Object inst;
            if (toFindA.isAssignableFrom(clazz)) {
                inst = this.getClassInstance(clazz.asSubclass(toFindA));
                if (inst == null) continue;
                foundClassesA.add(inst);
                continue;
            }
            if (!toFindB.isAssignableFrom(clazz) || (inst = this.getClassInstance(clazz.asSubclass(toFindB))) == null) continue;
            foundClassesB.add(inst);
        }
        return new Pair<List<A>, List<B>>(foundClassesA, foundClassesB);
    }

    private List<Class<?>> findConfigClasses(List<Class<?>> classes) {
        return classes == null ? new ArrayList() : classes.stream().filter(clazz -> clazz.isAnnotationPresent(Config.class)).toList();
    }

    private List<Class<?>> findItemClasses(List<Class<?>> classes) {
        return classes == null ? new ArrayList() : classes.stream().filter(CustomItem.class::isAssignableFrom).toList();
    }

    private List<Class<?>> getAllClasses(String packageName) throws URISyntaxException, IOException {
        Path root;
        String packagePath = packageName.replace('.', '/');
        URL resource = this.getClass().getClassLoader().getResource(packagePath);
        if (resource == null) {
            return List.of();
        }
        URI pkg = resource.toURI();
        ArrayList classes = new ArrayList();
        if (pkg.getScheme().equals("jar")) {
            try {
                root = FileSystems.getFileSystem(pkg).getPath(packagePath, new String[0]);
            }
            catch (FileSystemNotFoundException e) {
                root = FileSystems.newFileSystem(pkg, Collections.emptyMap()).getPath(packagePath, new String[0]);
            }
        } else {
            root = Paths.get(pkg);
        }
        try (Stream<Path> paths = Files.walk(root, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String path = file.toString().replace("/", ".");
                String name = path.substring(path.indexOf(packageName), path.length() - 6);
                try {
                    classes.add(Class.forName(name));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            });
        }
        return classes;
    }

    private <T> T getClassInstance(Class<? extends T> clazz) {
        T generic;
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<T> constr = null;
        Object[] params = null;
        try {
            for (Constructor<?> constructor : constructors) {
                if (constructor.isAnnotationPresent(NoInject.class)) continue;
                if (constructor.getParameterCount() == 0 && constr == null) {
                    constr = clazz.getDeclaredConstructor(new Class[0]);
                }
                if (constructor.getParameterCount() < 1 || constructor.getParameterTypes()[0] != SMPPlugin.class) continue;
                params = new Object[constructor.getParameterCount()];
                params[0] = this;
                constr = clazz.getDeclaredConstructor(SMPPlugin.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (constr == null) {
            return null;
        }
        for (Parameter parameter : constr.getParameters()) {
            if (!parameter.isAnnotationPresent(Property.class)) continue;
            Property annotation = parameter.getAnnotation(Property.class);
            String key = annotation.value().toLowerCase(Locale.ROOT);
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Property key cannot be empty at class " + clazz.getName() + "(" + this.getConstructorParams(constr) + ")");
            }
            Object object = switch (key) {
                case "time.ms" -> System.currentTimeMillis();
                case "time.ns" -> System.nanoTime();
                case "random.uuid" -> UUID.randomUUID();
                case "server.players" -> Bukkit.getOnlinePlayers();
                case "server.players.count" -> Bukkit.getOnlinePlayers().size();
                default -> {
                    String playerName;
                    String uuid;
                    if (key.startsWith("server.players.uuid.")) {
                        uuid = key.substring("server.players.uuid.".length());
                        yield Bukkit.getPlayer((UUID)UUID.fromString(uuid));
                    }
                    if (key.startsWith("server.players.")) {
                        playerName = key.substring("server.players.".length());
                        yield Bukkit.getPlayer((String)playerName);
                    }
                    yield key.startsWith("server.online.uuid.") ? Boolean.valueOf(Bukkit.getPlayer((UUID)UUID.fromString(uuid = key.substring("server.online.uuid.".length()))) != null) : (key.startsWith("server.online.") ? Boolean.valueOf(Bukkit.getPlayer((String)(playerName = key.substring("server.online.".length()))) != null) : null);
                }
            };
        }
        try {
            generic = constr.newInstance(params);
        }
        catch (Exception e) {
            try {
                generic = constr.newInstance(new Object[0]);
            }
            catch (Exception e1) {
                e.printStackTrace();
                return null;
            }
        }
        return generic;
    }

    private String getConstructorParams(Constructor<?> constr) {
        StringBuilder sb = new StringBuilder();
        for (Parameter parameter : constr.getParameters()) {
            for (Annotation annotation : parameter.getAnnotations()) {
                sb.append(annotation.toString()).append(" ");
            }
            sb.append(parameter.getType().getName()).append(", ");
        }
        return sb.toString().trim();
    }

    private List<Class<?>> findClasses(File directory, String pkgName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files == null) {
                return classes;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(this.findClasses(file, pkgName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                classes.add(Class.forName(pkgName + "." + file.getName().substring(0, file.getName().length() - 6), false, Thread.currentThread().getContextClassLoader()));
            }
        }
        return classes.stream().filter(clazz -> clazz.isAssignableFrom(Listener.class)).toList();
    }
}

