/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.menus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.helpers.StringHelper;
import me.ikevoodoo.smpcore.items.CustomItem;
import me.ikevoodoo.smpcore.menus.ItemData;
import me.ikevoodoo.smpcore.menus.Menu;
import me.ikevoodoo.smpcore.menus.MenuPage;
import me.ikevoodoo.smpcore.menus.PageData;
import me.ikevoodoo.smpcore.menus.functional.FunctionalMenu;
import me.ikevoodoo.smpcore.menus.functional.FunctionalPage;
import me.ikevoodoo.smpcore.text.messaging.MessageBuilder;
import me.ikevoodoo.smpcore.text.messaging.MessageProperty;
import me.ikevoodoo.smpcore.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class ReviveBeaconUI {
    private static final int HAS_PREV = 1;
    private static final int HAS_NEXT = 2;
    private static final List<CustomItem> items = new ArrayList<CustomItem>();
    private static final int[] i = new int[]{0};

    public static void createItems(SMPPlugin plugin) {
        items.forEach(plugin::destroyItem);
        items.clear();
        ReviveBeaconUI.i[0] = 0;
        plugin.getEliminationHandler().getEliminatedPlayers().forEach((uuid, revivedAt) -> {
            OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
            int n = i[0];
            i[0] = n + 1;
            items.add(plugin.createItem().id("revive_" + n).friendlyName(MessageBuilder.messageOf("Revive")).name(() -> MessageBuilder.builderOf("&a&lRevive ").add(offline.getName(), ChatColor.RED.asBungee()).build()).item(() -> {
                ItemStack stack = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta meta = (SkullMeta)stack.getItemMeta();
                meta.setOwningPlayer(offline);
                meta.setLore(List.of("", "\u00a7a\u00a7lBanned for \u00a7c" + StringUtils.formatTime(revivedAt.longValue())));
                stack.setItemMeta((ItemMeta)meta);
                return stack;
            }).bind((player, stack) -> {
                if (!plugin.getEliminationHandler().isEliminated((UUID)uuid)) {
                    MessageBuilder.create().add("The player ", ChatColor.RED.asBungee()).properties(MessageProperty.BOLD).add(offline.getName(), ChatColor.GREEN.asBungee()).properties(MessageProperty.BOLD).add(" is not eliminated.", ChatColor.RED.asBungee()).properties(MessageProperty.BOLD).build().send((Player)player);
                    return;
                }
                plugin.getEliminationHandler().reviveOffline(offline);
                player.closeInventory();
                player.playEffect(EntityEffect.TOTEM_RESURRECT);
                player.sendTitle(" ", "\u00a7a\u00a7lRevived \u00a7c\u00a7l" + offline.getName(), 10, 20, 10);
                CustomItem.remove(player, plugin.getItem("revive_beacon").orElseThrow(), 1);
            }).register());
        });
        plugin.createItem().id("revive_close").friendlyName(MessageBuilder.messageOf("Close")).name(() -> MessageBuilder.messageOf("&c&lClose")).material(() -> Material.BARRIER).bind((player, stack) -> player.closeInventory()).register();
        plugin.createItem().id("search_by_name").friendlyName(MessageBuilder.messageOf("Search")).name(() -> MessageBuilder.messageOf("&c&lCan't find the player?")).item(() -> {
            ItemStack stack = new ItemStack(Material.OAK_SIGN);
            ItemMeta meta = stack.getItemMeta();
            meta.setLore(List.of("", "\u00a7a\u00a7lSearch them by name!", "", "\u00a74\u00a7l(Not available yet)"));
            stack.setItemMeta(meta);
            return stack;
        }).register();
        plugin.createItem().id("sort_by_name").friendlyName(MessageBuilder.messageOf("Sort")).name(() -> MessageBuilder.messageOf("&c&lToo many players?")).item(() -> {
            ItemStack stack = new ItemStack(Material.SPYGLASS);
            ItemMeta meta = stack.getItemMeta();
            meta.setLore(List.of("", "\u00a7a\u00a7lSort trough them!", "", "\u00a74\u00a7l(Not available yet)"));
            stack.setItemMeta(meta);
            return stack;
        }).register();
    }

    public static void createMenus(SMPPlugin plugin) {
        Map<UUID, Number> eliminatedPlayers = plugin.getEliminationHandler().getEliminatedPlayers();
        int requiredPages = Math.max((int)Math.ceil((double)eliminatedPlayers.size() / 28.0), 1);
        List<Integer> pageNumbers = IntStream.range(0, requiredPages).boxed().toList();
        plugin.destroyMenu("lssmp_revive_beacon_menu");
        ((FunctionalMenu)plugin.createMenu().id("lssmp_revive_beacon_menu").each(pageNumbers).withPriority(0, (menu, index) -> ReviveBeaconUI.fillPage(plugin, ((FunctionalMenu)menu).page(PageData.of(54, MessageBuilder.messageOf(StringHelper.from("\u00a78%s/%s".formatted(index + 1, requiredPages)).prefix("                  ").postfix("                  ").middle(40, 2).toString()))), index, index == 0 && requiredPages > 1 ? 2 : 0)).withPriority(-1, (menu, index) -> ReviveBeaconUI.fillPage(plugin, ((FunctionalMenu)menu).page(PageData.of(54, MessageBuilder.messageOf(StringHelper.from("\u00a78%s/%s".formatted(index + 1, requiredPages)).prefix("                  ").postfix("                  ").middle(40, 2).toString()))), index, index > 0 ? 1 : 0)).with((menu, index) -> ReviveBeaconUI.fillPage(plugin, ((FunctionalMenu)menu).page(PageData.of(54, MessageBuilder.messageOf(StringHelper.from("\u00a78%s/%s".formatted(index + 1, requiredPages)).prefix("                  ").postfix("                  ").middle(40, 2).toString()))), index, 3)).execute()).register();
    }

    private static void fillPage(SMPPlugin plugin, FunctionalPage functionalPage, int pageId, int flags) {
        functionalPage.edit(page -> {
            page.onOpen(player -> {
                UUID id = player.getUniqueId();
                AtomicInteger i = new AtomicInteger(0);
                i.set(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> {
                    Player plr = Bukkit.getPlayer((UUID)id);
                    if (plr == null) {
                        Bukkit.getScheduler().cancelTask(i.get());
                        return;
                    }
                    Menu menu = plugin.getMenuHandler().get(plr);
                    if (menu == null) {
                        Bukkit.getScheduler().cancelTask(i.get());
                        return;
                    }
                    Optional<MenuPage> optional = menu.page(plr);
                    if (optional.isEmpty()) {
                        Bukkit.getScheduler().cancelTask(i.get());
                        return;
                    }
                    MenuPage menuPage = optional.get();
                    if (menuPage != page) {
                        Bukkit.getScheduler().cancelTask(i.get());
                        return;
                    }
                    ArrayList items = new ArrayList();
                    AtomicInteger slotOffset = new AtomicInteger();
                    menuPage.items((Player)player).forEach(data -> {
                        ItemStack stack = data.getStack();
                        ItemMeta meta = stack.getItemMeta();
                        ItemMeta skullMeta$temp = meta;
                        if (!(skullMeta$temp instanceof SkullMeta)) {
                            return;
                        }
                        SkullMeta skullMeta = (SkullMeta)skullMeta$temp;
                        OfflinePlayer owner = skullMeta.getOwningPlayer();
                        if (owner == null) {
                            return;
                        }
                        if (!plugin.getEliminationHandler().isEliminated(owner.getUniqueId())) {
                            slotOffset.getAndIncrement();
                            return;
                        }
                        long unbannedAt = plugin.getEliminationHandler().getEliminatedPlayers().get(owner.getUniqueId()).longValue();
                        if (unbannedAt == 0L) {
                            slotOffset.getAndIncrement();
                            return;
                        }
                        String time = StringUtils.formatTime(unbannedAt);
                        if (time.equalsIgnoreCase("now")) {
                            slotOffset.getAndIncrement();
                            return;
                        }
                        skullMeta.setLore(List.of("", "\u00a7a\u00a7lBanned for \u00a7c" + time));
                        stack.setItemMeta(meta);
                        items.add(ItemData.of(data.slot() - slotOffset.get(), stack));
                    });
                    page.item(items.toArray(new ItemData[0]));
                }, 0L, 20L));
            });
            page.fill(plugin.getItem("empty").orElseThrow().getItemStack());
            if ((flags & 2) == 2) {
                page.last(plugin.getItem("next").orElseThrow().getItemStack());
            }
            if ((flags & 1) == 1) {
                page.first(6, plugin.getItem("prev").orElseThrow().getItemStack());
            }
            for (int row = 1; row < 5; ++row) {
                for (int col = 1; col < 8; ++col) {
                    int slot = row * 9 + col;
                    int index = pageId * 28 + (slot - 10);
                    if (index < items.size()) {
                        page.item(ItemData.of(slot, items.get(index).getItemStack()));
                        continue;
                    }
                    page.item(ItemData.of(slot, new ItemStack(Material.AIR)));
                }
            }
            page.item(ItemData.of(48, plugin.getItem("search_by_name").orElseThrow().getItemStack()), ItemData.of(50, plugin.getItem("sort_by_name").orElseThrow().getItemStack()));
        });
    }
}

