/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.items.CustomItem;
import me.ikevoodoo.smpcore.menus.ItemData;
import me.ikevoodoo.smpcore.menus.MenuPage;
import me.ikevoodoo.smpcore.menus.PageData;
import me.ikevoodoo.smpcore.menus.functional.FunctionalMenu;
import me.ikevoodoo.smpcore.menus.functional.FunctionalPage;
import me.ikevoodoo.smpcore.recipes.RecipeData;
import me.ikevoodoo.smpcore.recipes.RecipeReplacement;
import me.ikevoodoo.smpcore.text.messaging.MessageBuilder;
import me.ikevoodoo.smpcore.utils.PDCUtils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class RecipeEditor {
    private static final int HAS_PREV = 1;
    private static final int HAS_NEXT = 2;

    public static void createMenus(SMPPlugin plugin) {
        ((FunctionalMenu)plugin.createMenu().id("lssmp_recipes_menu").each(plugin.getItems()).filter(item -> item.getRecipeData() == null).withPriority(0, (menu, item) -> RecipeEditor.editRecipePage(plugin, ((FunctionalMenu)menu).page(PageData.of(45, item.getFriendlyName())), item, 2)).withPriority(-1, (menu, item) -> RecipeEditor.editRecipePage(plugin, ((FunctionalMenu)menu).page(PageData.of(45, item.getFriendlyName())), item, 1)).with((menu, item) -> RecipeEditor.editRecipePage(plugin, ((FunctionalMenu)menu).page(PageData.of(45, item.getFriendlyName())), item, 3)).execute()).register();
    }

    private static void editRecipePage(SMPPlugin plugin, FunctionalPage functionalPage, CustomItem item, int flags) {
        RecipeData data = item.getRecipeData();
        RecipeChoice[] choices = data.choices();
        functionalPage.edit(page -> {
            page.fill(plugin.getItem("empty").orElseThrow().getItemStack());
            if ((flags & 2) == 2) {
                page.last(plugin.getItem("next").orElseThrow().getItemStack());
            }
            if ((flags & 1) == 1) {
                page.first(5, plugin.getItem("prev").orElseThrow().getItemStack());
            }
            RecipeEditor.drawRecipe(choices, page, 0);
            page.item(ItemData.of(24, item.getCleanStack()));
            RecipeEditor.createSettings(plugin, page, item);
        });
    }

    private static void createSettings(SMPPlugin plugin, MenuPage recipePage, CustomItem item) {
        CustomItem settingsItem = plugin.createItem().id("lssmp_recipe_settings_item_" + item.getId()).friendlyName(MessageBuilder.messageOf("\u00a7c\u00a7lSettings")).name(() -> MessageBuilder.messageOf("\u00a7c\u00a7cSettings")).material(() -> Material.COMPARATOR).bind((player, stack) -> {
            if (player.hasPermission("lssmp.recipe.settings")) {
                plugin.getMenuHandler().get("lssmp_recipe_settings_" + item.getId()).open((Player)player);
            }
        }).register();
        recipePage.onOpen(player -> {
            if (player.hasPermission("lssmp.recipe.settings")) {
                recipePage.item((Player)player, ItemData.of(8, settingsItem.getItemStack()));
            }
        });
        CustomItem recipeEditorItem = plugin.createItem().id("recipe_editor_" + item.getId()).friendlyName(MessageBuilder.messageOf("\u00a76\u00a7lRecipe Editor")).name(() -> MessageBuilder.messageOf("\u00a76\u00a7lRecipe Editor")).material(() -> Material.CRAFTING_TABLE).bind((player, stack) -> {
            if (!item.hasRecipeFile()) {
                MessageBuilder.messageOf("\u00a74\u00a7lUnavailable! \u00a7r\u00a7cThe item does not support recipe editing!").send((Player)player);
                return;
            }
            plugin.getMenuHandler().get("lssmp_recipe_editor_" + item.getId()).open((Player)player);
        }).register();
        plugin.createMenu().id("lssmp_recipe_settings_" + item.getId()).page(PageData.of(45, MessageBuilder.messageOf(settingsItem.getFriendlyName()))).edit(page -> {
            page.fill(plugin.getItem("empty").orElseThrow().getItemStack());
            page.item(ItemData.of(20, recipeEditorItem.getItemStack()));
            plugin.createItem().id("toggle_" + item.getId()).friendlyName(MessageBuilder.messageOf("Toggle")).name(() -> item.isEnabled() ? MessageBuilder.messageOf("\u00a7a\u00a7lEnabled") : MessageBuilder.messageOf("\u00a7c\u00a7lDisabled")).material(() -> item.isEnabled() ? Material.GREEN_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE).lore(() -> MessageBuilder.builderOf("\u00a76\u00a7lCick to ").add(item.isEnabled() ? "Disable" : "Enable", item.isEnabled() ? ChatColor.RED : ChatColor.GREEN).build()).bind((player, stack) -> {
                item.setEnabled(!item.isEnabled());
                page.item(ItemData.of(24, plugin.getItem("toggle_" + item.getId()).orElseThrow().getItemStack()));
            }).register();
            plugin.createItem().id("settings_" + item.getId() + "_back").friendlyName(MessageBuilder.messageOf("Back")).name(() -> MessageBuilder.messageOf("\u00a7c\u00a7lBack")).material(() -> Material.RED_STAINED_GLASS_PANE).bind((player, stack) -> plugin.getMenuHandler().get("lssmp_recipes_menu").openLast((Player)player)).register();
            page.first(5, plugin.getItem("settings_" + item.getId() + "_back").orElseThrow().getItemStack());
            page.onOpen(player -> page.item((Player)player, ItemData.of(24, plugin.getItem("toggle_" + item.getId()).orElseThrow().getItemStack())));
        }).done().register();
        plugin.createMenu().id("lssmp_recipe_editor_" + item.getId()).page(PageData.of(45, MessageBuilder.messageOf(recipeEditorItem.getFriendlyName()))).edit(page -> {
            page.fill(plugin.getItem("empty").orElseThrow().getItemStack());
            RecipeEditor.drawRecipe(item.getRecipeData().choices(), page, 1);
            plugin.createItem().id("confirm_recipe_editor_" + item.getId()).friendlyName(MessageBuilder.messageOf("Confirm")).name(() -> MessageBuilder.messageOf("\u00a7a\u00a7lConfirm")).material(() -> Material.LIME_STAINED_GLASS_PANE).bind((player, stack) -> {
                ItemStack[] stacks = RecipeEditor.getStacks(new ItemStack[9], page, player, 1);
                RecipeReplacement[] replacements = RecipeEditor.getReplacements(plugin, stacks);
                Material[] mats = (Material[])Arrays.stream(stacks).map(ItemStack::getType).toArray(Material[]::new);
                RecipeChoice[] choices = (RecipeChoice[])Arrays.stream(stacks).map(RecipeChoice.ExactChoice::new).toArray(RecipeChoice[]::new);
                Recipe recipe = item.getRecipeData().recipe();
                ShapedRecipe toWrite = null;
                Recipe shaped$temp = recipe;
                if (shaped$temp instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)shaped$temp;
                    ShapedRecipe shapedRecipe = new ShapedRecipe(shaped.getKey(), shaped.getResult());
                    shapedRecipe.shape(new String[]{"012", "345", "678"});
                    for (int i = 0; i < choices.length; ++i) {
                        shapedRecipe.setIngredient(("" + i).charAt(0), choices[i]);
                    }
                    toWrite = shapedRecipe;
                } else {
                    Recipe shapeless$temp = recipe;
                    if (shapeless$temp instanceof ShapelessRecipe) {
                        ShapelessRecipe shapeless = (ShapelessRecipe)shapeless$temp;
                        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(shapeless.getKey(), shapeless.getResult());
                        for (RecipeChoice choice : choices) {
                            shapelessRecipe.addIngredient(choice);
                        }
                    }
                }
                if (toWrite != null) {
                    plugin.getRecipeLoader().writeRecipe(item.getRecipeFile(), new RecipeData((Recipe)toWrite, mats, choices), replacements);
                }
                plugin.reload();
                plugin.getMenuHandler().get("lssmp_recipe_settings_" + item.getId()).open((Player)player);
            }).register();
            page.last(plugin.getItem("confirm_recipe_editor_" + item.getId()).orElseThrow().getItemStack());
        }).done().register();
    }

    private static void drawRecipe(RecipeChoice[] choices, MenuPage page, int offsetX) {
        int width = choices.length / 3;
        for (int x = 0; x < width; ++x) {
            int height = choices.length / 3;
            for (int y = 0; y < height; ++y) {
                RecipeChoice choice = choices[x + y * width];
                ItemStack stack = null;
                RecipeChoice recipeChoice = choice;
                if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
                    RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)recipeChoice;
                    stack = mat.getItemStack();
                } else {
                    recipeChoice = choice;
                    if (recipeChoice instanceof RecipeChoice.ExactChoice) {
                        RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)recipeChoice;
                        stack = exactChoice.getItemStack();
                    }
                }
                if (stack == null) continue;
                ItemMeta meta = stack.getItemMeta();
                if (meta != null) {
                    PersistentDataContainer pdc = meta.getPersistentDataContainer();
                    HashSet copy = new HashSet(pdc.getKeys());
                    copy.forEach(arg_0 -> ((PersistentDataContainer)pdc).remove(arg_0));
                    stack.setItemMeta(meta);
                }
                page.item(ItemData.of(11 + x + offsetX + 9 * y, stack));
            }
        }
    }

    private static ItemStack[] getStacks(ItemStack[] stacks, MenuPage page, Player player, int offsetX) {
        int width = stacks.length / 3;
        for (int x = 0; x < width; ++x) {
            int height = stacks.length / 3;
            for (int y = 0; y < height; ++y) {
                stacks[x + y * width] = page.item(player, 11 + x + offsetX + 9 * y).orElseGet(() -> new ItemStack(Material.AIR));
            }
        }
        return stacks;
    }

    private static RecipeReplacement[] getReplacements(SMPPlugin plugin, ItemStack ... stacks) {
        ArrayList replacements = new ArrayList();
        int i = 1;
        for (ItemStack stack : stacks) {
            if (stack != null && !stack.getType().isAir()) {
                ItemMeta meta = stack.getItemMeta();
                if (meta == null) continue;
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                Optional optional = PDCUtils.get(pdc, PersistentDataType.BYTE);
                int finalI = i;
                optional.ifPresent(pair -> plugin.getItem((String)pair.getFirst()).ifPresent(item -> replacements.add(RecipeReplacement.of(finalI, pair.getFirst()))));
            }
            ++i;
        }
        return replacements.toArray(new RecipeReplacement[0]);
    }
}

