/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.items;

import me.ikevoodoo.lssmp.config.ItemConfig;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.items.CustomItem;
import me.ikevoodoo.smpcore.items.ItemClickResult;
import me.ikevoodoo.smpcore.items.ItemClickState;
import me.ikevoodoo.smpcore.text.messaging.MessageBuilder;
import me.ikevoodoo.smpcore.utils.Pair;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class HeartItem
extends CustomItem {
    public HeartItem(SMPPlugin plugin) {
        super(plugin, "heart_item", MessageBuilder.messageOf("\u00a7c\u00a7lHeart Item"));
        this.addKey("heart").setDecreaseOnUse(true).bindConfig("items.heart").bindConfigOptions("heartRecipe.yml", "options").setRecipeFile("heartRecipe.yml").setAllowCombustion(false).setAllowCactusDamage(false).reload();
    }

    @Override
    public ItemStack createItem(Player player) {
        return new ItemStack(this.getRecipeOptions().mat());
    }

    @Override
    public Pair<NamespacedKey, Recipe> createRecipe() {
        this.unlockOnObtain(this.getRecipeData().materials());
        return new Pair<NamespacedKey, Recipe>(this.makeKey("heart_item_recipe"), this.getRecipeData().recipe());
    }

    @Override
    public ItemClickResult onClick(Player player, ItemStack itemStack, Action action) {
        double heartsToMax = this.getHeartsToMax(player);
        if (heartsToMax <= 0.0) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.7f);
            player.sendMessage(ItemConfig.HeartItem.Messages.maxHearts);
            return new ItemClickResult(ItemClickState.FAIL, true);
        }
        int maxItems = this.getMaxItems(heartsToMax, itemStack.getAmount(), player.isSneaking());
        double healthToAdd = (double)maxItems * MainConfig.Elimination.getHeartScale();
        String message = ItemConfig.HeartItem.Messages.increment.replace("%s", String.valueOf(maxItems));
        player.sendMessage(message);
        double newHealth = this.getPlugin().getHealthHelper().increaseMaxHealth((LivingEntity)player, healthToAdd);
        if (ItemConfig.HeartItem.claimingHeartHeals) {
            double health = player.getHealth();
            double toSet = health + player.getHealth();
            player.setHealth(Math.min(toSet, newHealth));
        }
        itemStack.setAmount(itemStack.getAmount() - maxItems);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.5f);
        return new ItemClickResult(ItemClickState.IGNORE, true);
    }

    private double getHeartsToMax(Player player) {
        double current;
        double max = MainConfig.Elimination.getMax();
        double diff = max - (current = this.getPlugin().getHealthHelper().getMaxHealth((LivingEntity)player));
        if (diff <= 0.0) {
            return 0.0;
        }
        return diff;
    }

    private int getMaxItems(double healthToMax, int stackSize, boolean isSneaking) {
        if (!isSneaking) {
            return healthToMax >= 1.0 ? 1 : 0;
        }
        int maxItems = (int)Math.floor(healthToMax / MainConfig.Elimination.getHeartScale());
        return Math.min(maxItems, stackSize);
    }
}

