/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.handlers.health;

import java.util.Optional;
import java.util.function.Function;
import me.ikevoodoo.smpcore.utils.PDCUtils;
import me.ikevoodoo.smpcore.utils.health.HealthHandler;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class WorldHealthHandler
implements HealthHandler {
    private final Function<World, NamespacedKey> worldKeyCreator;

    public WorldHealthHandler(Function<World, NamespacedKey> worldKeyCreator) {
        this.worldKeyCreator = worldKeyCreator;
    }

    @Override
    public void setMaxHealth(LivingEntity livingEntity, double amount) {
        this.setMaxHealth(livingEntity, amount, livingEntity.getWorld());
    }

    @Override
    public void setMaxHealth(LivingEntity livingEntity, double amount, World world) {
        NamespacedKey key = this.worldKeyCreator.apply(world);
        PersistentDataContainer pdc = livingEntity.getPersistentDataContainer();
        pdc.set(key, PersistentDataType.DOUBLE, (Object)amount);
        AttributeInstance attrib = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attrib == null) {
            return;
        }
        attrib.setBaseValue(amount);
    }

    @Override
    public double getMaxHealth(LivingEntity livingEntity) {
        World world = livingEntity.getWorld();
        PersistentDataContainer container = livingEntity.getPersistentDataContainer();
        Optional amount = PDCUtils.getPartial(container, world.getUID().toString(), PersistentDataType.DOUBLE);
        if (amount.isPresent()) {
            return (Double)amount.get().getSecond();
        }
        AttributeInstance instance = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        return instance == null ? 20.0 : instance.getBaseValue();
    }
}

