/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.config.bans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ikevoodoo.lssmp.config.bans.BanTimeData;
import me.ikevoodoo.lssmp.config.errors.ConfigError;
import me.ikevoodoo.lssmp.config.errors.Some;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;

public class BanConfig {
    public static final BanConfig INSTANCE = new BanConfig();
    private final Map<String, BanTimeData> banTimeDatas = new HashMap<String, BanTimeData>();

    private BanConfig() {
    }

    public List<ConfigError> load(ConfigurationSection section) {
        if (section == null) {
            return List.of(new ConfigError(null, "Section is null"));
        }
        this.banTimeDatas.clear();
        ArrayList<ConfigError> errors = new ArrayList<ConfigError>();
        for (String key : section.getKeys(false)) {
            Some<BanTimeData> data = BanTimeData.fromConfig(section.getConfigurationSection(key));
            if (data.isError()) {
                errors.add(data.error().addKey(key));
                continue;
            }
            this.banTimeDatas.put(key, data.key());
        }
        return errors;
    }

    public BanTimeData findByPermission(String permission) {
        for (Map.Entry<String, BanTimeData> entry : this.banTimeDatas.entrySet()) {
            if (!permission.equalsIgnoreCase(entry.getValue().permission())) continue;
            return entry.getValue();
        }
        return null;
    }

    public BanTimeData findByPermission(Permission permission) {
        return this.findByPermission(permission.getName());
    }

    public BanTimeData findHighest(Permissible permissible) {
        BanTimeData highest = null;
        for (Map.Entry<String, BanTimeData> entry : this.banTimeDatas.entrySet()) {
            if (!permissible.hasPermission(entry.getValue().permission()) || highest != null && highest.time() >= entry.getValue().time()) continue;
            highest = entry.getValue();
        }
        return highest;
    }

    public BanTimeData getByName(String name) {
        return this.banTimeDatas.get(name);
    }

    public Map<String, BanTimeData> getBanTimeDatas() {
        return new HashMap<String, BanTimeData>(this.banTimeDatas);
    }
}

