/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.config;

import java.util.List;
import me.ikevoodoo.smpcore.config.annotations.Config;
import org.bukkit.World;

@Config(value="config.yml")
public class MainConfig {
    public static boolean autoConfigReload = false;
    public static int doNotTouch_configVersion = 9;

    public static class Messages {

        public static class Errors {
            public static String requiresPlayer = "\u00a7cA player is required to perform this command!";
            public static String requiresArgument = "\u00a7cThe argument \"%s\" is required to perform this command!";
            public static String specifyAtLeastOne = "\u00a7cYou must specify at least one %s!";
            public static String notFound = "\u00a7c%s not found!";
        }
    }

    public static class Items {

        public static class HeartFragment {
            public static String displayName = "\u00a7c\u00a7lHeart Fragment.";
            public static List<String> lore = List.of("Use 4 of these to craft a heart!");
            public static int customModelData = 933;
        }

        public static class Beacon {
            public static String displayName = "\u00a7fRevive Beacon.";
            public static List<String> lore = List.of("Right click to revive!");
            public static int customModelData = 932;
        }

        public static class Heart {
            public static String displayName = "\u00a7c\u2764 \u00a7fExtra heart.";
            public static List<String> lore = List.of("Gives you an extra heart!");
            public static int customModelData = 931;
        }
    }

    public static class Elimination {
        public static boolean environmentStealsHearts = true;
        public static double environmentHealthScale = 1.0;
        public static double healthScale = 1.0;
        public static double maxHearts = 20.0;
        public static boolean useMaxHealth = true;
        public static double minHearts = 5.0;
        public static boolean useMinHealth = false;
        public static boolean banAtMinHealth = false;
        public static double defaultHearts = 10.0;
        public static boolean useReviveHearts = true;
        public static double reviveHearts = 10.0;
        public static boolean totemWorksInInventory = false;
        public static boolean alwaysDropHearts = false;
        public static boolean environmentDropHearts = false;
        public static boolean playersDropHearts = false;
        public static boolean fullInventoryHeartDrop = true;
        public static boolean allowSelfElimination = false;
        public static boolean perWorldHearts = false;
        public static List<String> allowedWorlds = List.of("all");

        public static boolean isWorldAllowed(World world) {
            return allowedWorlds.contains("all") || allowedWorlds.contains(world.getName());
        }

        public static double getMax() {
            return (useMaxHealth ? maxHearts : 1024.0) * 2.0;
        }

        public static double getMin() {
            return useMinHealth ? minHearts : 0.0;
        }

        public static double getHeartScale() {
            return healthScale * 2.0;
        }

        public static double getEnvironmentHeartScale() {
            return environmentHealthScale * 2.0;
        }

        public static class Bans {
            public static String banMessage = "\u00a7cYou have been eliminated!";
            public static boolean useBanTime = false;
            public static String banTime = "00:00:00.0000";
            public static boolean broadcastBan = false;
            public static String broadcastMessage = "\u00a7c%player% has lost all of their hearts and has been banned.";
        }
    }
}

