/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.commands.withdraw;

import me.ikevoodoo.lssmp.config.CommandConfig;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.lssmp.utils.Util;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.commands.CommandUsable;
import me.ikevoodoo.smpcore.commands.Context;
import me.ikevoodoo.smpcore.commands.SMPCommand;
import me.ikevoodoo.smpcore.commands.arguments.Argument;
import me.ikevoodoo.smpcore.commands.arguments.OptionalFor;
import me.ikevoodoo.smpcore.utils.health.HealthSetResult;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WithdrawCommand
extends SMPCommand {
    public WithdrawCommand(SMPPlugin plugin) {
        super(plugin, CommandConfig.WithdrawCommand.name, CommandConfig.WithdrawCommand.perms);
        this.setUsable(CommandUsable.PLAYER);
        this.setArgs(new Argument("amount", false, Integer.class, OptionalFor.ALL));
    }

    @Override
    public boolean execute(Context<?> context) {
        int count;
        int sum;
        double max;
        Player player = context.source(Player.class);
        int amount = Math.abs(context.args().get("amount", Integer.class, Integer.valueOf(1)));
        if ((double)amount > (max = this.getPlugin().getHealthHelper().getMaxHealth((LivingEntity)player) / MainConfig.Elimination.getHeartScale())) {
            if (CommandConfig.WithdrawCommand.withdrawEliminates) {
                this.getPlugin().getEliminationHandler().eliminate(player);
                player.kickPlayer(MainConfig.Elimination.Bans.banMessage);
                return true;
            }
            player.sendMessage(CommandConfig.WithdrawCommand.Messages.withdrawnTooMuch.replace("%max%", String.valueOf(max)));
            return true;
        }
        HealthSetResult result = this.getPlugin().getHealthHelper().decreaseMaxHealthIfOver((LivingEntity)player, (double)amount * MainConfig.Elimination.getHeartScale(), MainConfig.Elimination.getMin());
        if (result.isBelowMin()) {
            this.getPlugin().getEliminationHandler().eliminate(player);
            player.kickPlayer(MainConfig.Elimination.Bans.banMessage);
            return true;
        }
        if (!MainConfig.Elimination.fullInventoryHeartDrop && sum > 0) {
            double toAdd = (double)sum * MainConfig.Elimination.getHeartScale();
            double newHealth = this.getPlugin().getHealthHelper().increaseMaxHealth((LivingEntity)player, toAdd);
            player.setHealth(Math.min(toAdd, newHealth));
            player.sendMessage(CommandConfig.WithdrawCommand.Messages.notEnoughSpace.replace("%amount%", String.valueOf(sum)));
            return true;
        }
        for (sum = player.getInventory().addItem(new ItemStack[]{this.getPlugin().getItem("heart_item").orElseThrow().getItemStack(amount)}).values().stream().map(ItemStack::getAmount).reduce(0, Integer::sum).intValue(); sum > 0; sum -= count) {
            count = Math.min(sum, 64);
            Util.drop(this.getPlugin().getItem("heart_item").orElseThrow().getItemStack(count), player.getEyeLocation());
        }
        player.sendMessage(CommandConfig.WithdrawCommand.Messages.withdraw.replace("%amount%", String.valueOf(amount)));
        return true;
    }
}

