/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.commands.health;

import me.ikevoodoo.lssmp.config.CommandConfig;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.commands.Context;
import me.ikevoodoo.smpcore.commands.SMPCommand;
import me.ikevoodoo.smpcore.commands.arguments.Argument;
import me.ikevoodoo.smpcore.commands.arguments.OptionalFor;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class HealthSetCommand
extends SMPCommand {
    protected HealthSetCommand(SMPPlugin plugin) {
        super(plugin, CommandConfig.HealthCommand.HealthSetCommand.name, CommandConfig.HealthCommand.HealthSetCommand.perms);
        System.out.println("HealthSetCommand: " + CommandConfig.HealthCommand.HealthSetCommand.name);
        this.setArgs(new Argument("player", true, Player.class, OptionalFor.NONE), new Argument("hearts", true, Double.class, OptionalFor.NONE), new Argument("world", false, World.class, OptionalFor.ALL));
    }

    @Override
    public boolean execute(Context<?> context) {
        double hearts = context.args().get("hearts", Double.class) * MainConfig.Elimination.getHeartScale();
        Player player = context.args().get("player", Player.class);
        double oldHearts = this.getPlugin().getHealthHelper().getMaxHealth((LivingEntity)player) / MainConfig.Elimination.getHeartScale();
        if (context.args().has("world")) {
            World world = context.args().get("world", World.class);
            double setTo = this.getPlugin().getHealthHelper().setMaxHealth((LivingEntity)player, hearts, world);
            context.source().sendMessage(String.format(CommandConfig.HealthCommand.Messages.setInWorldMessage, player.getName(), setTo, world.getName(), oldHearts));
            return true;
        }
        this.getPlugin().getHealthHelper().setMaxHealthEverywhere((LivingEntity)player, hearts);
        context.source().sendMessage(String.format(CommandConfig.HealthCommand.Messages.setMessage, player.getName(), hearts, oldHearts));
        return true;
    }
}

