/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp;

import dev.refinedtech.configlang.scope.Scope;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.ikevoodoo.juerr.Printer;
import me.ikevoodoo.juerr.UserError;
import me.ikevoodoo.lssmp.bstats.Metrics;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.lssmp.config.ResourepackConfig;
import me.ikevoodoo.lssmp.config.bans.BanConfig;
import me.ikevoodoo.lssmp.handlers.health.GlobalHealthHandler;
import me.ikevoodoo.lssmp.handlers.health.WorldHealthHandler;
import me.ikevoodoo.lssmp.language.Language;
import me.ikevoodoo.lssmp.language.YamlConfigSection;
import me.ikevoodoo.lssmp.menus.RecipeEditor;
import me.ikevoodoo.lssmp.menus.ReviveBeaconUI;
import me.ikevoodoo.lssmp.menus.SharedItems;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.callbacks.eliminations.EliminationType;
import me.ikevoodoo.smpcore.handlers.placeholders.PlaceholderHandler;
import me.ikevoodoo.smpcore.utils.ExceptionUtils;
import me.ikevoodoo.smpcore.utils.Lazy;
import me.ikevoodoo.smpcore.utils.StringUtils;
import me.ikevoodoo.smpcore.utils.ThreadUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class LSSMP
extends SMPPlugin {
    public static final int CURRENT_CONFIG_VERSION = 9;
    private final Lazy<Language> lazyLanguage = new Lazy<Language>(() -> new Language(this));

    @Override
    public void onPreload() {
        UserError.setExceptionHandler();
        this.saveResource("heartRecipe.yml", false);
        this.saveResource("beaconRecipe.yml", false);
        this.saveResource("heartFragmentRecipe.yml", false);
        this.saveResource("events.yml", false);
        this.saveResource("bans.yml", false);
        new Metrics(this, 12177);
    }

    @Override
    public void whenEnabled() {
        this.loadHealthHandler();
        Printer<Logger> logger = new Printer<Logger>(this.getLogger()){

            @Override
            public void printf(String s, Object ... objects) {
                ((Logger)this.getOut()).log(Level.SEVERE, s, objects);
            }

            @Override
            public void printfln(String message, Object ... args) {
                this.printf(message + "\n", args);
            }
        };
        SharedItems.register(this);
        ReviveBeaconUI.createItems(this);
        if (this.isInstalled("PlaceholderAPI")) {
            PlaceholderHandler.create(this, "lssmp", "1.0.0").persist().onlineRequiresPlayer().online("raw_hearts", player -> String.valueOf(this.getHealthHelper().getMaxHearts((LivingEntity)player))).online("hearts", player -> StringUtils.removeTrailingZeros(String.valueOf(this.getHealthHelper().getMaxHearts((LivingEntity)player)))).register();
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            ArrayList toRevive = new ArrayList();
            this.getEliminationHandler().getEliminatedPlayers().forEach((uuid, time) -> {
                if (time.longValue() - System.currentTimeMillis() > 0L) {
                    return;
                }
                toRevive.add(uuid);
            });
            toRevive.forEach(uuid -> this.getEliminationHandler().reviveOffline(Bukkit.getOfflinePlayer((UUID)uuid)));
        }, 0L, 100L);
        this.getEliminationHandler().onCacheUpdated((uuid, number) -> {
            ReviveBeaconUI.createItems(this);
            ReviveBeaconUI.createMenus(this);
        });
        this.getEliminationHandler().listen(EliminationType.ELIMINATED, (eliminationType, player) -> {
            Scope scope = new Scope("elimination");
            scope.variables().set("player", new Object(){
                public final String name;
                public final String displayName;
                public final UUID uuid;
                {
                    this.name = player.getName();
                    this.displayName = player.getDisplayName();
                    this.uuid = player.getUniqueId();
                }
            });
            this.getLanguage().execute(YamlConfigSection.of(this.getConfigHandler().getYmlConfig("events.yml").getConfigurationSection("eliminated")), scope, new Object[0]);
        });
        this.getEliminationHandler().listen(EliminationType.REVIVED, (eliminationType, player) -> {
            if (MainConfig.Elimination.useReviveHearts) {
                this.getHealthHelper().setMaxHeartsEverywhere((LivingEntity)player, MainConfig.Elimination.reviveHearts);
            }
            Scope scope = new Scope("revived");
            scope.variables().set("player", new Object(){
                public final String name;
                public final String displayName;
                public final UUID uuid;
                {
                    this.name = player.getName();
                    this.displayName = player.getDisplayName();
                    this.uuid = player.getUniqueId();
                }
            });
            this.getLanguage().execute(YamlConfigSection.of(this.getConfigHandler().getYmlConfig("events.yml").getConfigurationSection("revived")), scope, new Object[0]);
        });
        this.reload();
        if (!this.getConfig().contains("doNotTouch_configVersion") || MainConfig.doNotTouch_configVersion < 9) {
            UserError.from("You're using an outdated version of the config!").addReason("The config version has changed").addHelp("Run /lsupgrade (Will reset all of your configs and restart)").addHelp("Make sure you don't change the option 'doNotTouch_configVersion' in the config").printAll(logger, "LSSMP: ");
        }
    }

    @Override
    public void whenDisabled() {
        ThreadUtils.stop(53261);
    }

    @Override
    public void onReload() {
        this.getResourcePackHandler().addResourcePack("pack", ResourepackConfig.getUrl());
        this.loadHealthHandler();
        this.reloadConfigs();
        RecipeEditor.createMenus(this);
        ReviveBeaconUI.createMenus(this);
        if (MainConfig.autoConfigReload) {
            try {
                WatchService service = FileSystems.getDefault().newWatchService();
                Path dir = this.getDataFolder().toPath();
                WatchKey key = dir.register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                ThreadUtils.start(53261, () -> {
                    while (!Thread.currentThread().isInterrupted()) {
                        if (key.pollEvents().isEmpty()) continue;
                        Bukkit.getScheduler().callSyncMethod((Plugin)this, () -> {
                            this.reload();
                            return true;
                        });
                    }
                    try {
                        service.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                this.getLogger().severe("Unable to use option 'autoConfigReload'");
                this.getLogger().severe("Go to https://pastebin.com and paste everything between the lines:");
                this.getLogger().severe("--------------------------");
                this.getLogger().severe(ExceptionUtils.asString(e));
                this.getLogger().severe("--------------------------");
                this.getLogger().severe("Once pasted, please click 'Create new Paste'");
                this.getLogger().severe("Then join https://refinedtech.dev/discord and create a ticket (check #ask-for-help)");
                this.getLogger().severe("And finally send the link in the extra info box that will be opened for you.");
            }
            return;
        }
        ThreadUtils.stop(53261);
    }

    private void reloadConfigs() {
        FileConfiguration bans = this.getConfigHandler().getYmlConfig("bans.yml");
        if (bans == null) {
            this.getLogger().severe("Unable to load bans.yml");
            return;
        }
        BanConfig.INSTANCE.load(bans.getConfigurationSection("banTimes"));
    }

    public Language getLanguage() {
        return this.lazyLanguage.get();
    }

    private void loadHealthHandler() {
        if (MainConfig.Elimination.perWorldHearts) {
            this.getHealthHelper().setHealthHandler(new WorldHealthHandler(world -> this.makeKey(world.getUID().toString())));
            return;
        }
        this.getHealthHelper().setHealthHandler(new GlobalHealthHandler());
    }

    public void saveResource(@NotNull String resourcePath, boolean replace) {
        if (resourcePath.isBlank()) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + this.getFile());
        }
        File outFile = new File(this.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IllegalStateException("Could not create path " + outDir);
        }
        if (outFile.exists() && !replace) {
            return;
        }
        try {
            Files.copy(in, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save resource " + resourcePath + " to " + outFile, e);
        }
    }
}

