/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.juerr.traces;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.ikevoodoo.juerr.ProjectInfo;
import me.ikevoodoo.juerr.traces.StackTraceCause;
import me.ikevoodoo.juerr.traces.StackTraceLine;

public class StackTraceHelper {
    private StackTraceHelper() {
    }

    public static List<StackTraceLine> getInvolved(Throwable throwable) {
        List<StackTraceLine> lines = Arrays.stream(throwable.getStackTrace()).map(element -> new StackTraceLine(StackTraceHelper.getClass(element.getClassName()), StackTraceHelper.getDeclaredMethod(element.getClassName(), element.getMethodName()), element.getLineNumber(), element.getFileName())).collect(Collectors.toList());
        Collections.reverse(lines);
        return lines;
    }

    public static StackTraceCause getCause(Class<?> clazz, List<StackTraceLine> stackTraceLines) {
        if (!ProjectInfo.isLoaded(clazz)) {
            return null;
        }
        List<Class<?>> classes = ProjectInfo.getClasses(clazz);
        ArrayList<StackTraceLine> last = new ArrayList<StackTraceLine>();
        for (StackTraceLine line : stackTraceLines) {
            Class<?> cl = line.clazz().get();
            if (!classes.contains(cl)) continue;
            last.add(line);
        }
        if (last.size() > 0) {
            int index = stackTraceLines.indexOf(last.get(last.size() - 1));
            return new StackTraceCause(last, stackTraceLines.get(Math.min(stackTraceLines.size() - 2, index) + 1));
        }
        return null;
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(String className, String name) {
        Class<?> clazz = StackTraceHelper.getClass(className);
        if (clazz == null) {
            return null;
        }
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }
}

