/*
 * Decompiled with CFR 0.152.
 */
package dev.refinedtech.configlang;

import dev.refinedtech.configlang.ConfigSection;
import dev.refinedtech.configlang.scope.Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class ConfigStructure {
    private final String key;
    private final List<ConfigStructure> required = new ArrayList<ConfigStructure>();
    private final boolean childrenRequired;

    public ConfigStructure(String key, ConfigStructure ... children) {
        this(key, children.length > 0, children);
    }

    public ConfigStructure(String key, boolean childrenRequired, ConfigStructure ... children) {
        this.key = key;
        this.childrenRequired = childrenRequired;
        Collections.addAll(this.required, children);
    }

    public static ConfigStructure keyStructure(String key) {
        return new ConfigStructure(key, new ConfigStructure[0]){

            @Override
            protected Object run(ConfigSection section, Scope scope, Object ... args) {
                return null;
            }
        };
    }

    public final Object execute(ConfigSection section, Consumer<String> error, Scope scope, Object ... args) {
        String err = this.matches(section);
        if (err != null) {
            if (error != null) {
                error.accept(err);
            }
            return null;
        }
        return this.run(section, scope, args);
    }

    public boolean returnsData() {
        return false;
    }

    protected abstract Object run(ConfigSection var1, Scope var2, Object ... var3);

    public final String matches(ConfigSection configuration) {
        if (!configuration.getName().equalsIgnoreCase(this.key)) {
            return String.format("The configuration %s is not of the same name as %s", configuration.getPath(), this.key());
        }
        for (ConfigStructure required : this.required) {
            if (required.childrenRequired() && !configuration.isConfigSection(required.key())) {
                return String.format("The key %s.%s should be a configuration section, however it %s!", configuration.getPath(), required.key(), configuration.contains(required.key()) ? "is not a configuration section" : "does not exist");
            }
            if (!required.children().isEmpty()) {
                if (!configuration.isConfigSection(required.key())) {
                    return String.format("The key %s.%s required child elements but none found!", configuration.getPath(), required.key());
                }
                Optional<ConfigSection> opt = configuration.getConfigSection(required.key());
                ConfigSection config = opt.orElse(null);
                if (config == null) {
                    return String.format("Could not fetch configuration %s.%s", configuration.getPath(), required.key());
                }
                String err = required.matches(config);
                if (err == null) continue;
                return err;
            }
            if (configuration.contains(required.key())) continue;
            return String.format("The configuration %s does not contain the required key %s", configuration.getPath(), required.key());
        }
        return null;
    }

    public final String key() {
        return this.key;
    }

    public final List<ConfigStructure> children() {
        return this.required;
    }

    public final boolean childrenRequired() {
        return this.childrenRequired;
    }
}

