/*
 * Decompiled with CFR 0.152.
 */
package ijuanito.com.lpc;

import ijuanito.com.lpc.Main;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Format {
    private TextComponent chat = new TextComponent();
    private Player p;
    private String message;
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public Format(Player p, String message) {
        this.p = p;
        this.message = message;
        this.initialize();
    }

    public TextComponent create(Player p) {
        BaseComponent[] arrayOfBaseComponent;
        String format = this.getFormat(p);
        for (BaseComponent comp : arrayOfBaseComponent = TextComponent.fromLegacyText((String)format)) {
            this.chat.addExtra(comp);
        }
        return this.chat;
    }

    public String getFormat(Player player) {
        CachedMetaData metaData = Main.luckPerms.getPlayerAdapter(Player.class).getMetaData((Object)player);
        String group = metaData.getPrimaryGroup();
        String format = Main.instance.getConfig().getString(Main.instance.getConfig().getString("group-formats." + group) != null ? "group-formats." + group : "chat-format").replace("{prefix}", metaData.getPrefix() != null ? metaData.getPrefix() : "").replace("{suffix}", metaData.getSuffix() != null ? metaData.getSuffix() : "").replace("{prefixes}", metaData.getPrefixes().keySet().stream().map(key -> (String)metaData.getPrefixes().get(key)).collect(Collectors.joining())).replace("{suffixes}", metaData.getSuffixes().keySet().stream().map(key -> (String)metaData.getSuffixes().get(key)).collect(Collectors.joining())).replace("{world}", player.getWorld().getName()).replace("{name}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{username-color}", metaData.getMetaValue("username-color") != null ? metaData.getMetaValue("username-color") : "").replace("{message-color}", metaData.getMetaValue("message-color") != null ? metaData.getMetaValue("message-color") : "");
        format = Format.colorize(Format.translateHexColorCodes(Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format));
        return format.replace("{message}", player.hasPermission("lpc.colorcodes") && player.hasPermission("lpc.rgbcodes") ? Format.colorize(Format.translateHexColorCodes(this.message)) : (player.hasPermission("lpc.colorcodes") ? Format.colorize(this.message) : (player.hasPermission("lpc.rgbcodes") ? Format.translateHexColorCodes(this.message) : this.message))).replace("%", "%%");
    }

    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    static String translateHexColorCodes(String message) {
        int colorChar = 167;
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    private void initialize() {
        this.setHoverEvent();
        this.setClickEvent();
        this.setSuggestCommand();
    }

    private void setHoverEvent() {
        String title = Format.setPAPI(this.p, Main.instance.getConfig().getString("Title"));
        String hovertext = Format.setPAPI(this.p, Main.instance.getConfig().getString("HoverText"));
        this.chat.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.setMainVariables(title)).append("\n" + this.setMainVariables(hovertext)).create()));
    }

    public static String setPAPI(Player p, String s) {
        return PlaceholderAPI.setPlaceholders((Player)p, (String)s);
    }

    private String setMainVariables(String s) {
        CachedMetaData metaData = Main.luckPerms.getPlayerAdapter(Player.class).getMetaData((Object)this.p);
        String format = s.replace("{prefix}", metaData.getPrefix() != null ? metaData.getPrefix() : "").replace("{suffix}", metaData.getSuffix() != null ? metaData.getSuffix() : "").replace("{prefixes}", metaData.getPrefixes().keySet().stream().map(key -> (String)metaData.getPrefixes().get(key)).collect(Collectors.joining())).replace("{suffixes}", metaData.getSuffixes().keySet().stream().map(key -> (String)metaData.getSuffixes().get(key)).collect(Collectors.joining())).replace("{world}", this.p.getWorld().getName()).replace("{name}", this.p.getName()).replace("{displayname}", this.p.getDisplayName()).replace("{username-color}", metaData.getMetaValue("username-color") != null ? metaData.getMetaValue("username-color") : "").replace("{message-color}", metaData.getMetaValue("message-color") != null ? metaData.getMetaValue("message-color") : "");
        format = Format.colorize(Format.translateHexColorCodes(Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)this.p, (String)format) : format));
        return format.replace("%", "%%");
    }

    private void setClickEvent() {
        if (!Main.instance.getConfig().getBoolean("PerformCommand")) {
            return;
        }
        this.chat.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.setMainVariables(Main.instance.getConfig().getString("Command"))));
    }

    private void setSuggestCommand() {
        if (!Main.instance.getConfig().getBoolean("SuggestCommand")) {
            return;
        }
        this.chat.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, this.setMainVariables(Main.instance.getConfig().getString("Command"))));
    }
}

