/*
 * Decompiled with CFR 0.152.
 */
package com.luizbebe.itemupgrade.utils.checkers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin javaPlugin;
    private int resourceID;
    private URL resourceURL;
    private String currentVersion;
    private String lastVersion;
    private UpdateCheckerResult updateCheckerResult;

    public UpdateChecker(JavaPlugin javaPlugin, int resourceID) {
        int lastVersion;
        this.javaPlugin = javaPlugin;
        try {
            this.resourceID = resourceID;
            this.resourceURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceID);
        }
        catch (Exception e) {
            return;
        }
        this.currentVersion = javaPlugin.getDescription().getVersion();
        this.lastVersion = this.getLastedVersion();
        if (this.lastVersion == null) {
            this.updateCheckerResult = UpdateCheckerResult.NONE_RESULT;
            return;
        }
        int currentVersion = Integer.parseInt(this.currentVersion.replace("v", "").replace(".", ""));
        this.updateCheckerResult = currentVersion < (lastVersion = Integer.parseInt(this.lastVersion.replace("v", "").replace(".", ""))) ? UpdateCheckerResult.OUT_DATED : (currentVersion == lastVersion ? UpdateCheckerResult.UP_TO_DATE : UpdateCheckerResult.UANRELEASED);
    }

    public String getLastedVersion() {
        try {
            URLConnection urlConnection = this.resourceURL.openConnection();
            return new BufferedReader(new InputStreamReader(urlConnection.getInputStream())).readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getResourceID() {
        return this.resourceID;
    }

    public String getResourceURL() {
        return "https://www.spigotmc.org/resources/" + this.resourceID;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getLastVersion() {
        return this.lastVersion;
    }

    public UpdateCheckerResult getUpdateCheckerResult() {
        return this.updateCheckerResult;
    }

    public void messageOutOfDated(CommandSender sender) {
        ArrayList<String> message = new ArrayList<String>();
        message.add("");
        message.add("\u00a7b[LB_Store] \u00a7fO plugin \u00a7b" + this.javaPlugin.getDescription().getName() + " \u00a7ftem uma nova atualiza\u00e7\u00e3o dispon\u00edvel.");
        message.add("");
        message.add("\u00a7b[LB_Store] \u00a7fVers\u00e3o Utilizada: \u00a7b" + this.javaPlugin.getDescription().getVersion());
        message.add("\u00a7b[LB_Store] \u00a7fVers\u00e3o Atual: \u00a7b" + this.lastVersion);
        message.add("");
        message.add("\u00a7b[LB_Store] \u00a7fCaso queira atualizar o plugin, entre neste link:");
        message.add("\u00a7b" + this.getResourceURL());
        message.add("");
        for (String line : message) {
            sender.sendMessage(line);
        }
    }

    public static enum UpdateCheckerResult {
        NONE_RESULT,
        OUT_DATED,
        UP_TO_DATE,
        UANRELEASED;

    }
}

