/*
 * Decompiled with CFR 0.152.
 */
package com.luizbebe.itemupgrade;

import com.luizbebe.itemupgrade.commands.GiveItemCommand;
import com.luizbebe.itemupgrade.events.StaffJoinEvent;
import com.luizbebe.itemupgrade.events.UpgradesEvents;
import com.luizbebe.itemupgrade.managers.MenuArmorManager;
import com.luizbebe.itemupgrade.managers.MenuAxeManager;
import com.luizbebe.itemupgrade.managers.MenuPanManager;
import com.luizbebe.itemupgrade.managers.MenuPickaxeManager;
import com.luizbebe.itemupgrade.managers.MenuSwordManager;
import com.luizbebe.itemupgrade.managers.apis.MessagesAPI;
import com.luizbebe.itemupgrade.managers.apis.SoundsAPI;
import com.luizbebe.itemupgrade.managers.itens.ArmorsItemManager;
import com.luizbebe.itemupgrade.managers.itens.AxeItemManager;
import com.luizbebe.itemupgrade.managers.itens.PanItemManager;
import com.luizbebe.itemupgrade.managers.itens.PickaxeItemManager;
import com.luizbebe.itemupgrade.managers.itens.SwordItemManager;
import com.luizbebe.itemupgrade.utils.checkers.UpdateChecker;
import com.luizbebe.itemupgrade.utils.files.FileManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main instance;
    private Economy econ = null;
    private UpdateChecker updateChecker;
    private MenuSwordManager menuSwordManager;
    private SwordItemManager swordItemManager;
    private MenuPickaxeManager menuPickaxeManager;
    private PickaxeItemManager pickaxeItemManager;
    private MenuAxeManager menuAxeManager;
    private AxeItemManager axeItemManager;
    private MenuPanManager menuPanManager;
    private PanItemManager panItemManager;
    private MenuArmorManager menuArmorManager;
    private ArmorsItemManager armorsItemManager;

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getVault();
            return;
        }
        this.saveDefaultConfig();
        instance = this;
        ConsoleCommandSender b = Bukkit.getConsoleSender();
        b.sendMessage("\u00a7b[LB_Store] \u00a77Obrigado por adquirir o plugin \u00a7b" + this.getDescription().getName() + "\u00a77 agrade\u00e7o a preferencia.");
        b.sendMessage("\u00a7b[LB_Store] \u00a7fDiscord: \u00a7bhttps://discord.gg/Yxnc7uTYk8");
        b.sendMessage("\u00a7b[" + this.getDescription().getName() + "] \u00a7fCriado por \u00a7bLuizBebe840");
        this.loading();
        this.loadingManagers();
        this.register();
        this.checkUpdate();
    }

    private void loading() {
        FileManager.createConfig("upgrades");
        MessagesAPI.loadingMessage();
        SoundsAPI.loadingSounds();
    }

    private void register() {
        this.getCommand("giveitem").setExecutor((CommandExecutor)new GiveItemCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new UpgradesEvents(), (Plugin)this);
    }

    public static Main getInstance() {
        return instance;
    }

    private void loadingManagers() {
        this.menuSwordManager = new MenuSwordManager();
        this.menuPickaxeManager = new MenuPickaxeManager();
        this.menuAxeManager = new MenuAxeManager();
        this.menuPanManager = new MenuPanManager();
        this.menuArmorManager = new MenuArmorManager();
        this.swordItemManager = new SwordItemManager();
        this.pickaxeItemManager = new PickaxeItemManager();
        this.axeItemManager = new AxeItemManager();
        this.panItemManager = new PanItemManager();
        this.armorsItemManager = new ArmorsItemManager();
    }

    private void checkUpdate() {
        this.updateChecker = new UpdateChecker(this, 94219);
        if (this.updateChecker.getUpdateCheckerResult().equals((Object)UpdateChecker.UpdateCheckerResult.OUT_DATED)) {
            this.updateChecker.messageOutOfDated((CommandSender)Bukkit.getConsoleSender());
            Bukkit.getPluginManager().registerEvents((Listener)new StaffJoinEvent(), (Plugin)this);
        }
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public Economy getBalance() {
        return this.econ;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider e = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (e == null) {
            return false;
        }
        this.econ = (Economy)e.getProvider();
        return this.econ != null;
    }

    private void getVault() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a7b[LB_ItemUpgrade] \u00a7cPlugin desativado, pois n\u00e3o foi possivel encontrar o Vault.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public MenuSwordManager getMenuSwordManager() {
        return this.menuSwordManager;
    }

    public MenuPickaxeManager getMenuPickaxeManager() {
        return this.menuPickaxeManager;
    }

    public MenuAxeManager getMenuAxeManager() {
        return this.menuAxeManager;
    }

    public MenuPanManager getMenuPanManager() {
        return this.menuPanManager;
    }

    public MenuArmorManager getMenuArmorManager() {
        return this.menuArmorManager;
    }

    public SwordItemManager getSwordItemManager() {
        return this.swordItemManager;
    }

    public PickaxeItemManager getPickaxeItemManager() {
        return this.pickaxeItemManager;
    }

    public AxeItemManager getAxeItemManager() {
        return this.axeItemManager;
    }

    public PanItemManager getPanItemManager() {
        return this.panItemManager;
    }

    public ArmorsItemManager getArmorsItemManager() {
        return this.armorsItemManager;
    }
}

